/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.NodeUpdates;

class NodeUpdatesIterator
implements Iterator<NodeUpdates> {
    private final IndexStoreView storeView;
    private final PrimitiveLongIterator nodeIdIterator;
    private NodeUpdates nextUpdate;

    NodeUpdatesIterator(IndexStoreView storeView, PrimitiveLongIterator nodeIdIterator) {
        this.storeView = storeView;
        this.nodeIdIterator = nodeIdIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.nextUpdate == null) {
            while (this.nodeIdIterator.hasNext()) {
                long nodeId = this.nodeIdIterator.next();
                NodeUpdates updates = this.storeView.nodeAsUpdates(nodeId);
                if (updates == null) continue;
                this.nextUpdate = updates;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public NodeUpdates next() {
        NodeUpdates update = null;
        if (this.hasNext()) {
            update = this.nextUpdate;
            this.nextUpdate = null;
        }
        return update;
    }
}

