/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.impl.api.PropertyValueComparison;

public class OrderedPropertyValues {
    private final DefinedProperty[] properties;
    public static final Comparator<OrderedPropertyValues> COMPARATOR = (left, right) -> {
        if (left.properties.length != right.properties.length) {
            throw new IllegalStateException("Comparing two OrderedPropertyValues of different lengths!");
        }
        int compare = 0;
        for (int i = 0; i < left.properties.length; ++i) {
            compare = PropertyValueComparison.COMPARE_VALUES.compare(left.properties[i].value(), right.properties[i].value());
            if (compare == 0) continue;
            return compare;
        }
        return compare;
    };

    public static OrderedPropertyValues ofUndefined(Object ... values) {
        return new OrderedPropertyValues((DefinedProperty[])Arrays.stream(values).map(value -> Property.property(-1, value)).toArray(DefinedProperty[]::new));
    }

    public static OrderedPropertyValues of(DefinedProperty[] values) {
        return new OrderedPropertyValues(values);
    }

    public static OrderedPropertyValues of(IndexQuery.ExactPredicate[] exactPreds) {
        DefinedProperty[] values = new DefinedProperty[exactPreds.length];
        for (int i = 0; i < exactPreds.length; ++i) {
            values[i] = Property.property(exactPreds[i].propertyKeyId(), exactPreds[i].value());
        }
        return new OrderedPropertyValues(values);
    }

    private OrderedPropertyValues(DefinedProperty[] properties) {
        this.properties = properties;
    }

    public Object valueAt(int position) {
        return this.properties[position].value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedPropertyValues that = (OrderedPropertyValues)o;
        if (that.properties.length != this.properties.length) {
            return false;
        }
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.properties[i].valueEquals(that.properties[i].value())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (DefinedProperty property : this.properties) {
            result = 31 * (result + property.valueHash());
        }
        return result;
    }

    public int size() {
        return this.properties.length;
    }

    public Object getSinglePropertyValue() {
        assert (this.properties.length == 1) : "Assumed single property but had " + this.properties.length;
        return this.properties[0].value();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "( ";
        for (DefinedProperty property : this.properties) {
            sb.append(sep);
            sep = ", ";
            sb.append(OrderedPropertyValues.quote(property.value()));
        }
        sb.append(" )");
        return sb.toString();
    }

    public static String quote(Object propertyValue) {
        if (propertyValue instanceof String) {
            return String.format("'%s'", propertyValue);
        }
        if (propertyValue.getClass().isArray()) {
            Class<?> type = propertyValue.getClass().getComponentType();
            if (type == Boolean.TYPE) {
                return Arrays.toString((boolean[])propertyValue);
            }
            if (type == Byte.TYPE) {
                return Arrays.toString((byte[])propertyValue);
            }
            if (type == Short.TYPE) {
                return Arrays.toString((short[])propertyValue);
            }
            if (type == Character.TYPE) {
                return Arrays.toString((char[])propertyValue);
            }
            if (type == Integer.TYPE) {
                return Arrays.toString((int[])propertyValue);
            }
            if (type == Long.TYPE) {
                return Arrays.toString((long[])propertyValue);
            }
            if (type == Float.TYPE) {
                return Arrays.toString((float[])propertyValue);
            }
            if (type == Double.TYPE) {
                return Arrays.toString((double[])propertyValue);
            }
            return Arrays.toString((Object[])propertyValue);
        }
        return String.valueOf(propertyValue);
    }
}

