/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.lang.reflect.Array;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;

class PropertyConversion {
    PropertyConversion() {
    }

    static DefinedProperty convertProperty(int propertyKeyId, Object value) {
        if (value instanceof String) {
            return Property.stringProperty(propertyKeyId, (String)value);
        }
        if (value instanceof Object[]) {
            return PropertyConversion.arrayProperty(propertyKeyId, (Object[])value);
        }
        if (value instanceof Long) {
            return Property.longProperty(propertyKeyId, (Long)value);
        }
        if (value instanceof Integer) {
            return Property.intProperty(propertyKeyId, (Integer)value);
        }
        if (value instanceof Boolean) {
            return Property.booleanProperty(propertyKeyId, (Boolean)value);
        }
        if (value instanceof Double) {
            return Property.doubleProperty(propertyKeyId, (Double)value);
        }
        if (value instanceof Float) {
            return Property.floatProperty(propertyKeyId, ((Float)value).floatValue());
        }
        if (value instanceof Short) {
            return Property.shortProperty(propertyKeyId, (Short)value);
        }
        if (value instanceof Byte) {
            return Property.byteProperty(propertyKeyId, (Byte)value);
        }
        if (value instanceof Character) {
            return Property.charProperty(propertyKeyId, ((Character)value).charValue());
        }
        if (value instanceof byte[]) {
            return Property.byteArrayProperty(propertyKeyId, (byte[])((byte[])value).clone());
        }
        if (value instanceof long[]) {
            return Property.longArrayProperty(propertyKeyId, (long[])((long[])value).clone());
        }
        if (value instanceof int[]) {
            return Property.intArrayProperty(propertyKeyId, (int[])((int[])value).clone());
        }
        if (value instanceof double[]) {
            return Property.doubleArrayProperty(propertyKeyId, (double[])((double[])value).clone());
        }
        if (value instanceof float[]) {
            return Property.floatArrayProperty(propertyKeyId, (float[])((float[])value).clone());
        }
        if (value instanceof boolean[]) {
            return Property.booleanArrayProperty(propertyKeyId, (boolean[])((boolean[])value).clone());
        }
        if (value instanceof char[]) {
            return Property.charArrayProperty(propertyKeyId, (char[])((char[])value).clone());
        }
        if (value instanceof short[]) {
            return Property.shortArrayProperty(propertyKeyId, (short[])((short[])value).clone());
        }
        if (value == null) {
            throw new IllegalArgumentException("[null] is not a supported property value");
        }
        throw new IllegalArgumentException(String.format("[%s:%s] is not a supported property value", value, value.getClass().getName()));
    }

    private static DefinedProperty arrayProperty(int propertyKeyId, Object[] value) {
        if (value instanceof String[]) {
            return Property.stringArrayProperty(propertyKeyId, PropertyConversion.copy(value, new String[value.length]));
        }
        if (value instanceof Byte[]) {
            return Property.byteArrayProperty(propertyKeyId, PropertyConversion.copy(value, new byte[value.length]));
        }
        if (value instanceof Long[]) {
            return Property.longArrayProperty(propertyKeyId, PropertyConversion.copy(value, new long[value.length]));
        }
        if (value instanceof Integer[]) {
            return Property.intArrayProperty(propertyKeyId, PropertyConversion.copy(value, new int[value.length]));
        }
        if (value instanceof Double[]) {
            return Property.doubleArrayProperty(propertyKeyId, PropertyConversion.copy(value, new double[value.length]));
        }
        if (value instanceof Float[]) {
            return Property.floatArrayProperty(propertyKeyId, PropertyConversion.copy(value, new float[value.length]));
        }
        if (value instanceof Boolean[]) {
            return Property.booleanArrayProperty(propertyKeyId, PropertyConversion.copy(value, new boolean[value.length]));
        }
        if (value instanceof Character[]) {
            return Property.charArrayProperty(propertyKeyId, PropertyConversion.copy(value, new char[value.length]));
        }
        if (value instanceof Short[]) {
            return Property.shortArrayProperty(propertyKeyId, PropertyConversion.copy(value, new short[value.length]));
        }
        throw new IllegalArgumentException(String.format("%s[] is not a supported property value type", value.getClass().getComponentType().getName()));
    }

    private static <T> T copy(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException("Property array value elements may not be null.");
            }
            Array.set(target, i, value[i]);
        }
        return target;
    }
}

