/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class ReadRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<PrimitiveLongIterator> {
    private final RecordStore<RECORD> store;
    private final Class<RECORD> klass;
    private final Predicate<RECORD> filter;
    private final int batchSize;

    public ReadRecordsStep(StageControl control, Configuration config, boolean inRecordWritingStage, RecordStore<RECORD> store, Predicate<RECORD> filter) {
        super(control, ">", config, ReadRecordsStep.parallelReading(config, inRecordWritingStage) ? 0 : 1, new StatsProvider[0]);
        this.store = store;
        this.filter = filter;
        this.klass = store.newRecord().getClass();
        this.batchSize = config.batchSize();
    }

    private static boolean parallelReading(Configuration config, boolean inRecordWritingStage) {
        return inRecordWritingStage && config.parallelRecordReadsWhenWriting() || !inRecordWritingStage && config.parallelRecordReads();
    }

    @Override
    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees | 1);
    }

    @Override
    protected void process(PrimitiveLongIterator idRange, BatchSender sender) throws Throwable {
        if (!idRange.hasNext()) {
            return;
        }
        long id = idRange.next();
        RECORD record = this.store.newRecord();
        AbstractBaseRecord[] batch = (AbstractBaseRecord[])Array.newInstance(this.klass, this.batchSize);
        int i = 0;
        try (RecordCursor<RECORD> cursor = this.store.newRecordCursor(record).acquire(id, RecordLoad.CHECK);){
            boolean hasNext = true;
            while (hasNext) {
                if (cursor.next(id) && !IdValidator.isReservedId(id) && (this.filter == null || this.filter.test(record))) {
                    batch[i++] = ((AbstractBaseRecord)record).clone();
                }
                if (!(hasNext = idRange.hasNext())) continue;
                id = idRange.next();
            }
        }
        sender.send(i == this.batchSize ? batch : Arrays.copyOf(batch, i));
    }
}

