/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.DeserializerFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputGroupsDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputRelationshipValidator;

public class CsvInput
implements Input {
    private final Iterable<DataFactory<InputNode>> nodeDataFactory;
    private final Header.Factory nodeHeaderFactory;
    private final Iterable<DataFactory<InputRelationship>> relationshipDataFactory;
    private final Header.Factory relationshipHeaderFactory;
    private final IdType idType;
    private final Configuration config;
    private final Groups groups = new Groups();
    private final Collector badCollector;
    private final int maxProcessors;

    public CsvInput(Iterable<DataFactory<InputNode>> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory<InputRelationship>> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, Collector badCollector, int maxProcessors) {
        this.maxProcessors = maxProcessors;
        this.assertSaneConfiguration(config);
        this.nodeDataFactory = nodeDataFactory;
        this.nodeHeaderFactory = nodeHeaderFactory;
        this.relationshipDataFactory = relationshipDataFactory;
        this.relationshipHeaderFactory = relationshipHeaderFactory;
        this.idType = idType;
        this.config = config;
        this.badCollector = badCollector;
    }

    private void assertSaneConfiguration(Configuration config) {
        HashMap<Character, String> delimiters = new HashMap<Character, String>();
        delimiters.put(Character.valueOf(config.delimiter()), "delimiter");
        this.checkUniqueCharacter(delimiters, config.arrayDelimiter(), "array delimiter");
        this.checkUniqueCharacter(delimiters, config.quotationCharacter(), "quotation character");
    }

    private void checkUniqueCharacter(Map<Character, String> characters, char character, String characterDescription) {
        String conflict = characters.put(Character.valueOf(character), characterDescription);
        if (conflict != null) {
            throw new IllegalArgumentException("Character '" + character + "' specified by " + characterDescription + " is the same as specified by " + conflict);
        }
    }

    @Override
    public InputIterable<InputNode> nodes() {
        return new InputIterable<InputNode>(){

            @Override
            public InputIterator<InputNode> iterator() {
                InputGroupsDeserializer.DeserializerFactory<InputNode> factory = DeserializerFactories.defaultNodeDeserializer(CsvInput.this.groups, CsvInput.this.config, CsvInput.this.idType, CsvInput.this.badCollector);
                return new InputGroupsDeserializer<InputNode>(CsvInput.this.nodeDataFactory.iterator(), CsvInput.this.nodeHeaderFactory, CsvInput.this.config, CsvInput.this.idType, CsvInput.this.maxProcessors, 1, factory, Validators.emptyValidator(), InputNode.class);
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public InputIterable<InputRelationship> relationships() {
        return new InputIterable<InputRelationship>(){

            @Override
            public InputIterator<InputRelationship> iterator() {
                InputGroupsDeserializer.DeserializerFactory<InputRelationship> factory = DeserializerFactories.defaultRelationshipDeserializer(CsvInput.this.groups, CsvInput.this.config, CsvInput.this.idType, CsvInput.this.badCollector);
                return new InputGroupsDeserializer<InputRelationship>(CsvInput.this.relationshipDataFactory.iterator(), CsvInput.this.relationshipHeaderFactory, CsvInput.this.config, CsvInput.this.idType, CsvInput.this.maxProcessors, 1, factory, new InputRelationshipValidator(), InputRelationship.class);
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
        return this.idType.idMapper(numberArrayFactory);
    }

    @Override
    public IdGenerator idGenerator() {
        return this.idType.idGenerator();
    }

    @Override
    public Collector badCollector() {
        return this.badCollector;
    }
}

