/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class ConstraintIndexCreator {
    private final IndexingService indexingService;
    private final Supplier<KernelAPI> kernelSupplier;
    private final PropertyAccessor propertyAccessor;
    private final boolean releaseSchemaLockWhenCreatingConstraint;

    public ConstraintIndexCreator(Supplier<KernelAPI> kernelSupplier, IndexingService indexingService, PropertyAccessor propertyAccessor, boolean releaseSchemaLockWhenCreatingConstraint) {
        this.kernelSupplier = kernelSupplier;
        this.indexingService = indexingService;
        this.propertyAccessor = propertyAccessor;
        this.releaseSchemaLockWhenCreatingConstraint = releaseSchemaLockWhenCreatingConstraint;
    }

    public long createUniquenessConstraintIndex(KernelStatement state, SchemaReadOperations schemaOps, LabelSchemaDescriptor descriptor) throws TransactionFailureException, CreateConstraintFailureException, DropIndexFailureException, UniquePropertyValueValidationException, AlreadyConstrainedException {
        IndexDescriptor index;
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema(descriptor);
        try {
            index = this.getOrCreateUniquenessConstraintIndex(state, schemaOps, descriptor);
        }
        catch (AlreadyConstrainedException e) {
            throw e;
        }
        catch (SchemaKernelException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, (Throwable)e);
        }
        boolean success = false;
        boolean reacquiredSchemaLock = false;
        Locks.Client locks = state.locks().pessimistic();
        try {
            long indexId = schemaOps.indexGetCommittedId(state, index);
            this.releaseSchemaLock(locks);
            this.awaitConstrainIndexPopulation(constraint, indexId);
            this.acquireSchemaLock(state, locks);
            reacquiredSchemaLock = true;
            this.indexingService.getIndexProxy(indexId).verifyDeferredConstraints(this.propertyAccessor);
            success = true;
            long l = indexId;
            return l;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new IllegalStateException(String.format("Index (%s) that we just created does not exist.", descriptor));
        }
        catch (IndexEntryConflictException e) {
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, e);
        }
        catch (IOException | InterruptedException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, (Throwable)e);
        }
        finally {
            if (!success) {
                if (!reacquiredSchemaLock) {
                    this.acquireSchemaLock(state, locks);
                }
                this.dropUniquenessConstraintIndex(index);
            }
        }
    }

    private void acquireSchemaLock(KernelStatement state, Locks.Client locks) {
        if (this.releaseSchemaLockWhenCreatingConstraint) {
            locks.acquireExclusive(state.lockTracer(), ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        }
    }

    private void releaseSchemaLock(Locks.Client locks) {
        if (this.releaseSchemaLockWhenCreatingConstraint) {
            locks.releaseExclusive(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        }
    }

    public void dropUniquenessConstraintIndex(IndexDescriptor descriptor) throws TransactionFailureException, DropIndexFailureException {
        try (KernelTransaction transaction = this.kernelSupplier.get().newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
             Statement statement = transaction.acquireStatement();){
            ((KernelStatement)statement).txState().indexDoDrop(descriptor);
            transaction.success();
        }
    }

    private void awaitConstrainIndexPopulation(UniquenessConstraintDescriptor constraint, long indexId) throws InterruptedException, UniquePropertyValueValidationException {
        try {
            this.indexingService.getIndexProxy(indexId).awaitStoreScanCompleted();
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException(String.format("Index (indexId=%d) that we just created does not exist.", indexId));
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, (IndexEntryConflictException)cause);
            }
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, cause);
        }
    }

    public IndexDescriptor getOrCreateUniquenessConstraintIndex(KernelStatement state, SchemaReadOperations schemaOps, LabelSchemaDescriptor schema) throws SchemaKernelException {
        IndexDescriptor descriptor = schemaOps.indexGetForSchema(state, schema);
        if (descriptor != null) {
            if (descriptor.type() == IndexDescriptor.Type.UNIQUE) {
                if (schemaOps.indexGetOwningUniquenessConstraintId(state, descriptor) == null) {
                    return descriptor;
                }
                throw new AlreadyConstrainedException(ConstraintDescriptorFactory.uniqueForSchema(schema), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new StatementTokenNameLookup(state.readOperations()));
            }
            throw new AlreadyIndexedException(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        }
        return this.createConstraintIndex(schema);
    }

    /*
     * Exception decompiling
     */
    public IndexDescriptor createConstraintIndex(LabelSchemaDescriptor schema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

