/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.api.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class DefaultTransactionTracer
implements TransactionTracer,
LogRotationMonitor {
    private final SystemNanoClock clock;
    private final Monitor monitor;
    private final JobScheduler jobScheduler;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong accumulatedTotalTimeNanos = new AtomicLong();
    private long startTimeNanos;
    private final LogRotateEvent logRotateEvent = new LogRotateEvent(){

        @Override
        public void close() {
            DefaultTransactionTracer.this.updateCountersAndNotifyListeners();
        }
    };
    private final LogAppendEvent logAppendEvent = new LogAppendEvent(){

        @Override
        public void close() {
        }

        @Override
        public void setLogRotated(boolean logRotated) {
        }

        @Override
        public LogRotateEvent beginLogRotate() {
            DefaultTransactionTracer.this.startTimeNanos = DefaultTransactionTracer.this.clock.nanos();
            return DefaultTransactionTracer.this.logRotateEvent;
        }

        @Override
        public SerializeTransactionEvent beginSerializeTransaction() {
            return SerializeTransactionEvent.NULL;
        }

        @Override
        public LogForceWaitEvent beginLogForceWait() {
            return LogForceWaitEvent.NULL;
        }

        @Override
        public LogForceEvent beginLogForce() {
            return LogForceEvent.NULL;
        }
    };
    private final CommitEvent commitEvent = new CommitEvent(){

        @Override
        public void close() {
        }

        @Override
        public LogAppendEvent beginLogAppend() {
            return DefaultTransactionTracer.this.logAppendEvent;
        }

        @Override
        public StoreApplyEvent beginStoreApply() {
            return StoreApplyEvent.NULL;
        }
    };
    private final TransactionEvent transactionEvent = new TransactionEvent(){

        @Override
        public void setSuccess(boolean success) {
        }

        @Override
        public void setFailure(boolean failure) {
        }

        @Override
        public CommitEvent beginCommitEvent() {
            return DefaultTransactionTracer.this.commitEvent;
        }

        @Override
        public void close() {
        }

        @Override
        public void setTransactionType(String transactionTypeName) {
        }

        @Override
        public void setReadOnly(boolean wasReadOnly) {
        }
    };

    public DefaultTransactionTracer(Monitor monitor, JobScheduler jobScheduler) {
        this(Clocks.nanoClock(), monitor, jobScheduler);
    }

    public DefaultTransactionTracer(SystemNanoClock clock, Monitor monitor, JobScheduler jobScheduler) {
        this.clock = clock;
        this.monitor = monitor;
        this.jobScheduler = jobScheduler;
    }

    @Override
    public TransactionEvent beginTransaction() {
        return this.transactionEvent;
    }

    @Override
    public long numberOfLogRotationEvents() {
        return this.counter.get();
    }

    @Override
    public long logRotationAccumulatedTotalTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.accumulatedTotalTimeNanos.get());
    }

    private void updateCountersAndNotifyListeners() {
        this.counter.incrementAndGet();
        long lastEventTime = this.clock.nanos() - this.startTimeNanos;
        this.accumulatedTotalTimeNanos.addAndGet(lastEventTime);
        this.jobScheduler.schedule(JobScheduler.Groups.metricsEvent, () -> {
            long millis = TimeUnit.NANOSECONDS.toMillis(lastEventTime);
            this.monitor.lastLogRotationEventDuration(millis);
        });
    }

    public static interface Monitor {
        public void lastLogRotationEventDuration(long var1);
    }
}

