/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts.keys;

import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;

abstract class IndexKey
implements CountsKey {
    private final long indexId;
    private final CountsKeyType type;

    IndexKey(long indexId, CountsKeyType type) {
        this.indexId = indexId;
        this.type = type;
    }

    public long indexId() {
        return this.indexId;
    }

    public String toString() {
        return String.format("IndexKey[%s:%d]", this.type.name(), this.indexId);
    }

    @Override
    public CountsKeyType recordType() {
        return this.type;
    }

    public int hashCode() {
        return 31 * (int)this.indexId + this.type.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return ((IndexKey)other).indexId() == this.indexId;
    }

    @Override
    public int compareTo(CountsKey other) {
        if (other instanceof IndexKey) {
            return (int)(this.indexId - ((IndexKey)other).indexId());
        }
        return this.recordType().ordinal() - other.recordType().ordinal();
    }
}

