/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RecordCursors
implements AutoCloseable {
    private final RecordCursor<NodeRecord> node;
    private final RecordCursor<RelationshipRecord> relationship;
    private final RecordCursor<RelationshipGroupRecord> relationshipGroup;
    private final RecordCursor<PropertyRecord> property;
    private final RecordCursor<DynamicRecord> propertyString;
    private final RecordCursor<DynamicRecord> propertyArray;
    private final RecordCursor<DynamicRecord> label;

    public RecordCursors(NeoStores neoStores) {
        this.node = RecordCursors.newCursor(neoStores.getNodeStore());
        this.relationship = RecordCursors.newCursor(neoStores.getRelationshipStore());
        this.relationshipGroup = RecordCursors.newCursor(neoStores.getRelationshipGroupStore());
        this.property = RecordCursors.newCursor(neoStores.getPropertyStore());
        this.propertyString = RecordCursors.newCursor(neoStores.getPropertyStore().getStringStore());
        this.propertyArray = RecordCursors.newCursor(neoStores.getPropertyStore().getArrayStore());
        this.label = RecordCursors.newCursor(neoStores.getNodeStore().getDynamicLabelStore());
    }

    private static <R extends AbstractBaseRecord> RecordCursor<R> newCursor(RecordStore<R> store) {
        return store.newRecordCursor(store.newRecord()).acquire(store.getNumberOfReservedLowIds(), RecordLoad.NORMAL);
    }

    @Override
    public void close() {
        IOUtils.closeAll(RuntimeException.class, (AutoCloseable[])new RecordCursor[]{this.node, this.relationship, this.relationshipGroup, this.property, this.propertyArray, this.propertyString, this.label});
    }

    public RecordCursor<NodeRecord> node() {
        return this.node;
    }

    public RecordCursor<RelationshipRecord> relationship() {
        return this.relationship;
    }

    public RecordCursor<RelationshipGroupRecord> relationshipGroup() {
        return this.relationshipGroup;
    }

    public RecordCursor<PropertyRecord> property() {
        return this.property;
    }

    public RecordCursor<DynamicRecord> propertyArray() {
        return this.propertyArray;
    }

    public RecordCursor<DynamicRecord> propertyString() {
        return this.propertyString;
    }

    public RecordCursor<DynamicRecord> label() {
        return this.label;
    }
}

