/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.NeoStoresDiagnostics;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.UnexpectedStoreVersionException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.ReadOnlyCountsTracker;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;

public class NeoStores
implements AutoCloseable {
    private static final String STORE_ALREADY_CLOSED_MESSAGE = "Specified store was already closed.";
    private static final String STORE_NOT_INITIALIZED_TEMPLATE = "Specified store was not initialized. Please specify %s as one of the stores types that should be open to be able to use it.";
    private static final StoreType[] STORE_TYPES = StoreType.values();
    private final Predicate<StoreType> INSTANTIATED_RECORD_STORES = new Predicate<StoreType>(){

        @Override
        public boolean test(StoreType type) {
            return type.isRecordStore() && NeoStores.this.stores[type.ordinal()] != null;
        }
    };
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final PageCache pageCache;
    private final LogProvider logProvider;
    private final VersionContextSupplier versionContextSupplier;
    private final boolean createIfNotExist;
    private final File storeDir;
    private final File neoStoreFileName;
    private final StoreType[] initializedStores;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final RecordFormats recordFormats;
    private final Object[] stores;
    private final OpenOption[] openOptions;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isStorePresent(PageCache pageCache, File storeDir) {
        File metaDataStore = new File(storeDir, "neostore");
        try (PagedFile ignore = pageCache.map(metaDataStore, MetaDataStore.getPageSize(pageCache), new OpenOption[0]);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    NeoStores(File neoStoreFileName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, FileSystemAbstraction fileSystemAbstraction, VersionContextSupplier versionContextSupplier, RecordFormats recordFormats, boolean createIfNotExist, StoreType[] storeTypes, OpenOption[] openOptions) {
        this.neoStoreFileName = neoStoreFileName;
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.logProvider = logProvider;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.versionContextSupplier = versionContextSupplier;
        this.recordFormats = recordFormats;
        this.createIfNotExist = createIfNotExist;
        this.openOptions = openOptions;
        this.storeDir = neoStoreFileName.getParentFile();
        this.verifyRecordFormat();
        this.stores = new Object[StoreType.values().length];
        for (StoreType type : storeTypes) {
            this.getOrCreateStore(type);
        }
        this.initializedStores = storeTypes;
    }

    public File getStoreDir() {
        return this.storeDir;
    }

    private File getStoreFile(String substoreName) {
        return new File(this.neoStoreFileName.getPath() + substoreName);
    }

    @Override
    public void close() {
        RuntimeException ex = null;
        for (StoreType type : STORE_TYPES) {
            try {
                this.closeStore(type);
            }
            catch (RuntimeException t) {
                ex = (RuntimeException)Exceptions.chain(ex, (Throwable)t);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void verifyRecordFormat() {
        try {
            String actualStoreVersion;
            RecordFormats actualStoreFormat;
            String expectedStoreVersion = this.recordFormats.storeVersion();
            long record = MetaDataStore.getRecord(this.pageCache, this.neoStoreFileName, MetaDataStore.Position.STORE_VERSION);
            if (record != -1L && !this.isCompatibleFormats(actualStoreFormat = RecordFormatSelector.selectForVersion(actualStoreVersion = MetaDataStore.versionLongToString(record)))) {
                throw new UnexpectedStoreVersionException(actualStoreVersion, expectedStoreVersion);
            }
        }
        catch (NoSuchFileException expectedStoreVersion) {
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private boolean isCompatibleFormats(RecordFormats storeFormat) {
        return FormatFamily.isSameFamily(this.recordFormats, storeFormat) && this.recordFormats.hasSameCapabilities(storeFormat, CapabilityType.FORMAT) && this.recordFormats.generation() >= storeFormat.generation();
    }

    private void closeStore(StoreType type) {
        int i = type.ordinal();
        if (this.stores[i] != null) {
            try {
                type.close(this, this.stores[i]);
            }
            finally {
                this.stores[i] = null;
            }
        }
    }

    public void flush(IOLimiter limiter) {
        try {
            CountsTracker counts = (CountsTracker)this.stores[StoreType.COUNTS.ordinal()];
            if (counts != null) {
                counts.rotate(this.getMetaDataStore().getLastCommittedTransactionId());
            }
            if (!limiter.isLimited() && this.config.get(GraphDatabaseSettings.checkpoint_flush_parallel).booleanValue() && this.pageCache instanceof MuninnPageCache) {
                MuninnPageCache cache = (MuninnPageCache)this.pageCache;
                cache.experimentalFlushAndForceParallelUnsynchronised();
            } else {
                this.pageCache.flushAndForce(limiter);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", e);
        }
    }

    private Object openStore(StoreType type) {
        Object store;
        int storeIndex = type.ordinal();
        this.stores[storeIndex] = store = type.open(this);
        return store;
    }

    <T extends CommonAbstractStore> T initialize(T store) {
        store.initialise(this.createIfNotExist);
        return store;
    }

    private Object getStore(StoreType storeType) {
        Object store = this.stores[storeType.ordinal()];
        if (store == null) {
            String message = ArrayUtil.contains(this.initializedStores, storeType) ? STORE_ALREADY_CLOSED_MESSAGE : String.format(STORE_NOT_INITIALIZED_TEMPLATE, storeType.name());
            throw new IllegalStateException(message);
        }
        return store;
    }

    private Object getOrCreateStore(StoreType storeType) {
        Object store = this.stores[storeType.ordinal()];
        if (store == null) {
            store = this.openStore(storeType);
        }
        return store;
    }

    public MetaDataStore getMetaDataStore() {
        return (MetaDataStore)this.getStore(StoreType.META_DATA);
    }

    public NodeStore getNodeStore() {
        return (NodeStore)this.getStore(StoreType.NODE);
    }

    private DynamicArrayStore getNodeLabelStore() {
        return (DynamicArrayStore)this.getStore(StoreType.NODE_LABEL);
    }

    public RelationshipStore getRelationshipStore() {
        return (RelationshipStore)this.getStore(StoreType.RELATIONSHIP);
    }

    public RelationshipTypeTokenStore getRelationshipTypeTokenStore() {
        return (RelationshipTypeTokenStore)this.getStore(StoreType.RELATIONSHIP_TYPE_TOKEN);
    }

    private DynamicStringStore getRelationshipTypeTokenNamesStore() {
        return (DynamicStringStore)this.getStore(StoreType.RELATIONSHIP_TYPE_TOKEN_NAME);
    }

    public LabelTokenStore getLabelTokenStore() {
        return (LabelTokenStore)this.getStore(StoreType.LABEL_TOKEN);
    }

    private DynamicStringStore getLabelTokenNamesStore() {
        return (DynamicStringStore)this.getStore(StoreType.LABEL_TOKEN_NAME);
    }

    public PropertyStore getPropertyStore() {
        return (PropertyStore)this.getStore(StoreType.PROPERTY);
    }

    private DynamicStringStore getStringPropertyStore() {
        return (DynamicStringStore)this.getStore(StoreType.PROPERTY_STRING);
    }

    private DynamicArrayStore getArrayPropertyStore() {
        return (DynamicArrayStore)this.getStore(StoreType.PROPERTY_ARRAY);
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return (PropertyKeyTokenStore)this.getStore(StoreType.PROPERTY_KEY_TOKEN);
    }

    private DynamicStringStore getPropertyKeyTokenNamesStore() {
        return (DynamicStringStore)this.getStore(StoreType.PROPERTY_KEY_TOKEN_NAME);
    }

    public RecordStore<RelationshipGroupRecord> getRelationshipGroupStore() {
        return (RelationshipGroupStore)this.getStore(StoreType.RELATIONSHIP_GROUP);
    }

    public SchemaStore getSchemaStore() {
        return (SchemaStore)this.getStore(StoreType.SCHEMA);
    }

    public CountsTracker getCounts() {
        return (CountsTracker)this.getStore(StoreType.COUNTS);
    }

    private CountsTracker createWritableCountsTracker(File fileName) {
        return new CountsTracker(this.logProvider, this.fileSystemAbstraction, this.pageCache, this.config, fileName, this.versionContextSupplier);
    }

    private ReadOnlyCountsTracker createReadOnlyCountsTracker(File fileName) {
        return new ReadOnlyCountsTracker(this.logProvider, this.fileSystemAbstraction, this.pageCache, this.config, fileName);
    }

    private Iterable<CommonAbstractStore> instantiatedRecordStores() {
        FilteringIterator storeTypes = new FilteringIterator(Iterators.iterator((Object[])STORE_TYPES), this.INSTANTIATED_RECORD_STORES);
        return Iterators.loop((Iterator)new IteratorWrapper<CommonAbstractStore, StoreType>((Iterator)storeTypes){

            protected CommonAbstractStore underlyingObjectToObject(StoreType type) {
                return (CommonAbstractStore)NeoStores.this.stores[type.ordinal()];
            }
        });
    }

    public void makeStoreOk() {
        for (CommonAbstractStore store : this.instantiatedRecordStores()) {
            store.makeStoreOk();
        }
    }

    public void verifyStoreOk() {
        this.visitStore(new Visitor<CommonAbstractStore, RuntimeException>(){

            public boolean visit(CommonAbstractStore store) {
                store.checkStoreOk();
                return false;
            }
        });
    }

    public void logVersions(Logger msgLog) {
        msgLog.log("Store versions:");
        for (CommonAbstractStore store : this.instantiatedRecordStores()) {
            store.logVersions(msgLog);
        }
    }

    public void logIdUsage(Logger msgLog) {
        msgLog.log("Id usage:");
        for (CommonAbstractStore store : this.instantiatedRecordStores()) {
            store.logIdUsage(msgLog);
        }
    }

    public void visitStore(Visitor<CommonAbstractStore, RuntimeException> visitor) {
        for (CommonAbstractStore store : this.instantiatedRecordStores()) {
            store.visitStore(visitor);
        }
    }

    public void rebuildCountStoreIfNeeded() throws IOException {
        this.getCounts().start();
    }

    public void deleteIdGenerators() {
        this.visitStore(new Visitor<CommonAbstractStore, RuntimeException>(){

            public boolean visit(CommonAbstractStore store) throws RuntimeException {
                store.deleteIdGenerator();
                return false;
            }
        });
    }

    public void assertOpen() {
        if (this.stores[StoreType.NODE.ordinal()] == null) {
            throw new IllegalStateException("Database has been shutdown");
        }
    }

    CommonAbstractStore createDynamicArrayStore(String storeName, IdType idType, Setting<Integer> blockSizeProperty) {
        return this.createDynamicArrayStore(storeName, idType, this.config.get(blockSizeProperty));
    }

    CommonAbstractStore createDynamicArrayStore(String storeName, IdType idType, int blockSize) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size of dynamic array store should be positive integer.");
        }
        File storeFile = this.getStoreFile(storeName);
        return this.initialize(new DynamicArrayStore(storeFile, this.config, idType, this.idGeneratorFactory, this.pageCache, this.logProvider, blockSize, this.recordFormats.dynamic(), this.recordFormats.storeVersion(), this.openOptions));
    }

    CommonAbstractStore createNodeStore(String storeName) {
        File storeFile = this.getStoreFile(storeName);
        return this.initialize(new NodeStore(storeFile, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicArrayStore)this.getOrCreateStore(StoreType.NODE_LABEL), this.recordFormats, this.openOptions));
    }

    CommonAbstractStore createPropertyKeyTokenStore(String storeName) {
        File storeFile = this.getStoreFile(storeName);
        return this.initialize(new PropertyKeyTokenStore(storeFile, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrCreateStore(StoreType.PROPERTY_KEY_TOKEN_NAME), this.recordFormats, this.openOptions));
    }

    CommonAbstractStore createPropertyStore(String storeName) {
        File storeFile = this.getStoreFile(storeName);
        return this.initialize(new PropertyStore(storeFile, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrCreateStore(StoreType.PROPERTY_STRING), (PropertyKeyTokenStore)this.getOrCreateStore(StoreType.PROPERTY_KEY_TOKEN), (DynamicArrayStore)this.getOrCreateStore(StoreType.PROPERTY_ARRAY), this.recordFormats, this.openOptions));
    }

    CommonAbstractStore createRelationshipStore(String storeName) {
        File file = this.getStoreFile(storeName);
        return this.initialize(new RelationshipStore(file, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats, this.openOptions));
    }

    CommonAbstractStore createDynamicStringStore(String storeName, IdType idType, Setting<Integer> blockSizeProperty) {
        return this.createDynamicStringStore(storeName, idType, this.config.get(blockSizeProperty));
    }

    CommonAbstractStore createDynamicStringStore(String storeName, IdType idType, int blockSize) {
        File storeFile = this.getStoreFile(storeName);
        return this.initialize(new DynamicStringStore(storeFile, this.config, idType, this.idGeneratorFactory, this.pageCache, this.logProvider, blockSize, this.recordFormats.dynamic(), this.recordFormats.storeVersion(), this.openOptions));
    }

    CommonAbstractStore createRelationshipTypeTokenStore(String storeName) {
        File storeFile = this.getStoreFile(storeName);
        return this.initialize(new RelationshipTypeTokenStore(storeFile, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrCreateStore(StoreType.RELATIONSHIP_TYPE_TOKEN_NAME), this.recordFormats, this.openOptions));
    }

    CommonAbstractStore createLabelTokenStore(String storeName) {
        File fileName = this.getStoreFile(storeName);
        return this.initialize(new LabelTokenStore(fileName, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrCreateStore(StoreType.LABEL_TOKEN_NAME), this.recordFormats, this.openOptions));
    }

    CommonAbstractStore createSchemaStore(String storeName) {
        File fileName = this.getStoreFile(storeName);
        return this.initialize(new SchemaStore(fileName, this.config, IdType.SCHEMA, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats, this.openOptions));
    }

    CommonAbstractStore createRelationshipGroupStore(String storeName) {
        File storeFile = this.getStoreFile(storeName);
        return this.initialize(new RelationshipGroupStore(storeFile, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats, this.openOptions));
    }

    CountsTracker createCountStore(String storeName) {
        File storeFile = this.getStoreFile(storeName);
        boolean readOnly = this.config.get(GraphDatabaseSettings.read_only);
        CountsTracker counts = readOnly ? this.createReadOnlyCountsTracker(storeFile) : this.createWritableCountsTracker(storeFile);
        final NeoStores neoStores = this;
        counts.setInitializer(new DataInitializer<CountsAccessor.Updater>(){
            private final Log log;
            {
                this.log = NeoStores.this.logProvider.getLog(MetaDataStore.class);
            }

            @Override
            public void initialize(CountsAccessor.Updater updater) {
                this.log.warn("Missing counts store, rebuilding it.");
                new CountsComputer(neoStores, NeoStores.this.pageCache).initialize(updater);
                this.log.warn("Counts store rebuild completed.");
            }

            @Override
            public long initialVersion() {
                return ((MetaDataStore)NeoStores.this.getOrCreateStore(StoreType.META_DATA)).getLastCommittedTransactionId();
            }
        });
        try {
            counts.init();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to initialize counts store", e);
        }
        return counts;
    }

    CommonAbstractStore createMetadataStore() {
        return this.initialize(new MetaDataStore(this.neoStoreFileName, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats.metaData(), this.recordFormats.storeVersion(), this.openOptions));
    }

    public void registerDiagnostics(DiagnosticsManager diagnosticsManager) {
        diagnosticsManager.registerAll(NeoStoresDiagnostics.class, this);
    }

    public <RECORD extends AbstractBaseRecord> RecordStore<RECORD> getRecordStore(StoreType type) {
        return (RecordStore)this.getStore(type);
    }
}

