/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.ThrowingLongFunction;
import org.neo4j.helpers.collection.CastingIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.OrderedPropertyValues;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.schema.NodeSchemaMatcher;
import org.neo4j.kernel.impl.api.store.NodeLoadingIterator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class ConstraintEnforcingEntityOperations
implements EntityOperations,
SchemaWriteOperations {
    private final EntityWriteOperations entityWriteOperations;
    private final EntityReadOperations entityReadOperations;
    private final SchemaWriteOperations schemaWriteOperations;
    private final SchemaReadOperations schemaReadOperations;
    private final ConstraintSemantics constraintSemantics;
    private final NodeSchemaMatcher nodeSchemaMatcher;

    public ConstraintEnforcingEntityOperations(ConstraintSemantics constraintSemantics, EntityWriteOperations entityWriteOperations, EntityReadOperations entityReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaReadOperations schemaReadOperations) {
        this.constraintSemantics = constraintSemantics;
        this.entityWriteOperations = entityWriteOperations;
        this.entityReadOperations = entityReadOperations;
        this.schemaWriteOperations = schemaWriteOperations;
        this.schemaReadOperations = schemaReadOperations;
        this.nodeSchemaMatcher = new NodeSchemaMatcher(entityReadOperations);
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException, ConstraintValidationException {
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            if (!node.hasLabel(labelId)) {
                Iterator<ConstraintDescriptor> constraints = this.schemaReadOperations.constraintsGetForLabel(state, labelId);
                while (constraints.hasNext()) {
                    IndexBackedConstraintDescriptor uniqueConstraint;
                    IndexQuery.ExactPredicate[] propertyValues;
                    ConstraintDescriptor constraint = constraints.next();
                    if (!constraint.enforcesUniqueness() || (propertyValues = this.getAllPropertyValues(state, (uniqueConstraint = (IndexBackedConstraintDescriptor)constraint).schema(), node)) == null) continue;
                    this.validateNoExistingNodeWithExactValues(state, uniqueConstraint, propertyValues, node.id());
                }
            }
        }
        return this.entityWriteOperations.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException, ConstraintValidationException {
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            Iterator<ConstraintDescriptor> constraints = this.getConstraintsInvolvingProperty(state, property.propertyKeyId());
            CastingIterator uniquenessConstraints = new CastingIterator(constraints, IndexBackedConstraintDescriptor.class);
            this.nodeSchemaMatcher.onMatchingSchema(state, uniquenessConstraints, node, property.propertyKeyId(), (constraint, propertyIds) -> {
                Object previousValue;
                if (propertyIds.contains(property.propertyKeyId()) && property.valueEquals(previousValue = this.nodeGetProperty(state, node, property.propertyKeyId()))) {
                    return;
                }
                this.validateNoExistingNodeWithExactValues(state, (IndexBackedConstraintDescriptor)constraint, this.getAllPropertyValues(state, constraint.schema(), node, property), node.id());
            });
        }
        return this.entityWriteOperations.nodeSetProperty(state, nodeId, property);
    }

    private Iterator<ConstraintDescriptor> getConstraintsInvolvingProperty(KernelStatement state, int propertyId) {
        Iterator<ConstraintDescriptor> allConstraints = this.schemaReadOperations.constraintsGetAll(state);
        return Iterators.filter(SchemaDescriptorPredicates.hasProperty(propertyId), allConstraints);
    }

    private IndexQuery.ExactPredicate[] getAllPropertyValues(KernelStatement state, SchemaDescriptor schema, NodeItem node) {
        return this.getAllPropertyValues(state, schema, node, DefinedProperty.NO_SUCH_PROPERTY);
    }

    private IndexQuery.ExactPredicate[] getAllPropertyValues(KernelStatement state, SchemaDescriptor schema, NodeItem node, DefinedProperty changedProperty) {
        int k;
        int[] schemaPropertyIds = schema.getPropertyIds();
        IndexQuery.ExactPredicate[] values = new IndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        Cursor<PropertyItem> nodePropertyCursor = this.nodeGetProperties(state, node);
        int changedPropId = changedProperty.propertyKeyId();
        while (nodePropertyCursor.next()) {
            PropertyItem property = (PropertyItem)nodePropertyCursor.get();
            int nodePropertyId = property.propertyKeyId();
            int k2 = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)nodePropertyId);
            if (k2 < 0) continue;
            if (nodePropertyId != changedPropId) {
                values[k2] = IndexQuery.exact(nodePropertyId, property.value());
            }
            ++nMatched;
        }
        if (changedPropId != -1 && (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropId)) >= 0) {
            values[k] = IndexQuery.exact(changedPropId, changedProperty.value());
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private void validateNoExistingNodeWithExactValues(KernelStatement state, IndexBackedConstraintDescriptor constraint, IndexQuery.ExactPredicate[] propertyValues, long modifiedNode) throws ConstraintValidationException {
        try {
            IndexDescriptor index = constraint.ownedIndexDescriptor();
            this.assertIndexOnline(state, index);
            int labelId = index.schema().getLabelId();
            state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.INDEX_ENTRY, ResourceTypes.indexEntryResourceId(labelId, propertyValues));
            long existing = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, index, propertyValues);
            if (existing != -1L && existing != modifiedNode) {
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(existing, -1L, OrderedPropertyValues.of(propertyValues)));
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException(constraint, (Throwable)e);
        }
    }

    private void assertIndexOnline(KernelStatement state, IndexDescriptor indexDescriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.schemaReadOperations.indexGetState(state, indexDescriptor)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.schemaReadOperations.indexGetFailure(state, indexDescriptor));
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.entityWriteOperations.nodeDelete(state, nodeId);
    }

    @Override
    public int nodeDetachDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException, KernelException {
        return this.entityWriteOperations.nodeDetachDelete(state, nodeId);
    }

    @Override
    public long relationshipCreate(KernelStatement statement, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipCreate(statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.entityWriteOperations.relationshipDelete(state, relationshipId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        return this.entityWriteOperations.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        return this.entityWriteOperations.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        return this.entityWriteOperations.graphSetProperty(state, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        return this.entityWriteOperations.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        return this.entityWriteOperations.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        return this.entityWriteOperations.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return this.entityReadOperations.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator indexQuery(KernelStatement statement, IndexDescriptor index, IndexQuery[] predicates) throws IndexNotFoundKernelException, IndexNotApplicableKernelException {
        return this.entityReadOperations.indexQuery(statement, index, predicates);
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(KernelStatement state, IndexDescriptor index, IndexQuery.ExactPredicate ... predicates) throws IndexNotFoundKernelException, IndexBrokenKernelException, IndexNotApplicableKernelException {
        this.assertIndexOnline(state, index);
        this.assertPredicatesMatchSchema(index.schema(), predicates);
        int labelId = index.schema().getLabelId();
        Locks.Client locks = state.locks().optimistic();
        LockTracer lockTracer = state.lockTracer();
        long indexEntryId = ResourceTypes.indexEntryResourceId(labelId, predicates);
        locks.acquireShared(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
        long nodeId = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, index, predicates);
        if (-1L == nodeId) {
            locks.releaseShared(ResourceTypes.INDEX_ENTRY, indexEntryId);
            locks.acquireExclusive(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
            nodeId = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, index, predicates);
            if (-1L != nodeId) {
                locks.acquireShared(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
                locks.releaseExclusive(ResourceTypes.INDEX_ENTRY, indexEntryId);
            }
        }
        return nodeId;
    }

    private void assertPredicatesMatchSchema(LabelSchemaDescriptor schema, IndexQuery.ExactPredicate[] predicates) throws IndexNotApplicableKernelException {
        int[] propertyIds = schema.getPropertyIds();
        if (propertyIds.length != predicates.length) {
            throw new IndexNotApplicableKernelException(String.format("The index specifies %d properties, but only %d lookup predicates were given.", propertyIds.length, predicates.length));
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].propertyKeyId() == propertyIds[i]) continue;
            throw new IndexNotApplicableKernelException(String.format("The index has the property id %d in position %d, but the lookup property id was %d.", propertyIds[i], i, predicates[i].propertyKeyId()));
        }
    }

    @Override
    public long nodesCountIndexed(KernelStatement statement, IndexDescriptor index, long nodeId, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        return this.entityReadOperations.nodesCountIndexed(statement, index, nodeId, value);
    }

    @Override
    public boolean graphHasProperty(KernelStatement state, int propertyKeyId) {
        return this.entityReadOperations.graphHasProperty(state, propertyKeyId);
    }

    @Override
    public Object graphGetProperty(KernelStatement state, int propertyKeyId) {
        return this.entityReadOperations.graphGetProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement state) {
        return this.entityReadOperations.graphGetPropertyKeys(state);
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        return this.entityWriteOperations.nodeCreate(statement);
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement state) {
        return this.entityReadOperations.nodesGetAll(state);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll(KernelStatement state) {
        return this.entityReadOperations.relationshipsGetAll(state);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.entityReadOperations.relationshipVisit(statement, relId, visitor);
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        return this.entityReadOperations.nodeCursorById(statement, nodeId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(KernelStatement statement, long relId) throws EntityNotFoundException {
        return this.entityReadOperations.relationshipCursorById(statement, relId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll(KernelStatement statement) {
        return this.entityReadOperations.relationshipCursorGetAll(statement);
    }

    @Override
    public Cursor<PropertyItem> nodeGetProperties(KernelStatement statement, NodeItem node) {
        return this.entityReadOperations.nodeGetProperties(statement, node);
    }

    @Override
    public Object nodeGetProperty(KernelStatement statement, NodeItem node, int propertyKeyId) {
        return this.entityReadOperations.nodeGetProperty(statement, node, propertyKeyId);
    }

    @Override
    public boolean nodeHasProperty(KernelStatement statement, NodeItem node, int propertyKeyId) {
        return this.entityReadOperations.nodeHasProperty(statement, node, propertyKeyId);
    }

    @Override
    public PrimitiveIntCollection nodeGetPropertyKeys(KernelStatement statement, NodeItem node) {
        return this.entityReadOperations.nodeGetPropertyKeys(statement, node);
    }

    @Override
    public Cursor<PropertyItem> relationshipGetProperties(KernelStatement statement, RelationshipItem relationship) {
        return this.entityReadOperations.relationshipGetProperties(statement, relationship);
    }

    @Override
    public Object relationshipGetProperty(KernelStatement statement, RelationshipItem relationship, int propertyKeyId) {
        return this.entityReadOperations.relationshipGetProperty(statement, relationship, propertyKeyId);
    }

    @Override
    public boolean relationshipHasProperty(KernelStatement statement, RelationshipItem relationship, int propertyKeyId) {
        return this.entityReadOperations.relationshipHasProperty(statement, relationship, propertyKeyId);
    }

    @Override
    public PrimitiveIntCollection relationshipGetPropertyKeys(KernelStatement statement, RelationshipItem relationship) {
        return this.entityReadOperations.relationshipGetPropertyKeys(statement, relationship);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(KernelStatement statement, NodeItem node, Direction direction) {
        return this.entityReadOperations.nodeGetRelationships(statement, node, direction);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(KernelStatement statement, NodeItem node, Direction direction, int[] relTypes) {
        return this.entityReadOperations.nodeGetRelationships(statement, node, direction, relTypes);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException, RepeatedPropertyInCompositeSchemaException {
        return this.schemaWriteOperations.indexCreate(state, descriptor);
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.schemaWriteOperations.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.schemaWriteOperations.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public NodeKeyConstraintDescriptor nodeKeyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException, RepeatedPropertyInCompositeSchemaException {
        NodeLoadingIterator nodes = new NodeLoadingIterator(this.nodesGetForLabel(state, descriptor.getLabelId()), (ThrowingLongFunction<Cursor<NodeItem>, EntityNotFoundException>)((ThrowingLongFunction)id -> this.nodeCursorById(state, id)));
        this.constraintSemantics.validateNodeKeyConstraint((Iterator<Cursor<NodeItem>>)((Object)nodes), descriptor, (node, propertyKey) -> this.entityReadOperations.nodeHasProperty(state, (NodeItem)node, (int)propertyKey));
        return this.schemaWriteOperations.nodeKeyConstraintCreate(state, descriptor);
    }

    @Override
    public UniquenessConstraintDescriptor uniquePropertyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException, RepeatedPropertyInCompositeSchemaException {
        return this.schemaWriteOperations.uniquePropertyConstraintCreate(state, descriptor);
    }

    @Override
    public NodeExistenceConstraintDescriptor nodePropertyExistenceConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, RepeatedPropertyInCompositeSchemaException {
        NodeLoadingIterator nodes = new NodeLoadingIterator(this.nodesGetForLabel(state, descriptor.getLabelId()), (ThrowingLongFunction<Cursor<NodeItem>, EntityNotFoundException>)((ThrowingLongFunction)id -> this.nodeCursorById(state, id)));
        this.constraintSemantics.validateNodePropertyExistenceConstraint((Iterator<Cursor<NodeItem>>)((Object)nodes), descriptor, (node, propertyKey) -> this.entityReadOperations.nodeHasProperty(state, (NodeItem)node, (int)propertyKey));
        return this.schemaWriteOperations.nodePropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public RelExistenceConstraintDescriptor relationshipPropertyExistenceConstraintCreate(KernelStatement state, RelationTypeSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, RepeatedPropertyInCompositeSchemaException {
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorGetAll(state);){
            this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(cursor, descriptor, (relationship, propertyKey) -> this.entityReadOperations.relationshipHasProperty(state, (RelationshipItem)relationship, (int)propertyKey));
        }
        return this.schemaWriteOperations.relationshipPropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public void constraintDrop(KernelStatement state, ConstraintDescriptor constraint) throws DropConstraintFailureException {
        this.schemaWriteOperations.constraintDrop(state, constraint);
    }

    @Override
    public long nodesGetCount(KernelStatement statement) {
        return this.entityReadOperations.nodesGetCount(statement);
    }

    @Override
    public long relationshipsGetCount(KernelStatement statement) {
        return this.entityReadOperations.relationshipsGetCount(statement);
    }

    @Override
    public boolean nodeExists(KernelStatement statement, long id) {
        return this.entityReadOperations.nodeExists(statement, id);
    }

    @Override
    public PrimitiveIntSet relationshipTypes(KernelStatement statement, NodeItem nodeItem) {
        return this.entityReadOperations.relationshipTypes(statement, nodeItem);
    }

    @Override
    public int degree(KernelStatement statement, NodeItem nodeItem, Direction direction) {
        return this.entityReadOperations.degree(statement, nodeItem, direction);
    }

    @Override
    public int degree(KernelStatement statement, NodeItem nodeItem, Direction direction, int relType) {
        return this.entityReadOperations.degree(statement, nodeItem, direction, relType);
    }
}

