/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.Arrays;
import java.util.Collection;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

public class InputNode
extends InputEntity {
    private final Group group;
    private final Object id;
    private String[] labels;
    private Long labelField;

    public InputNode(String sourceDescription, long lineNumber, long position, Object id, Object[] properties, Long firstPropertyId, String[] labels, Long labelField) {
        this(sourceDescription, lineNumber, position, Group.GLOBAL, id, properties, firstPropertyId, labels, labelField);
    }

    public InputNode(String sourceDescription, long lineNumber, long position, Group group, Object id, Object[] properties, Long firstPropertyId, String[] labels, Long labelField) {
        super(sourceDescription, lineNumber, position, properties, firstPropertyId);
        this.group = group;
        this.id = id;
        this.labels = labels;
        this.labelField = labelField;
    }

    public Group group() {
        return this.group;
    }

    public Object id() {
        return this.id;
    }

    public String[] labels() {
        return this.labels;
    }

    public boolean hasLabelField() {
        return this.labelField != null;
    }

    public Long labelField() {
        return this.labelField;
    }

    @Override
    protected void toStringFields(Collection<Pair<String, ?>> fields) {
        super.toStringFields(fields);
        fields.add(Pair.of((Object)"id", (Object)this.id));
        fields.add(Pair.of((Object)"group", (Object)this.group));
        if (this.hasLabelField()) {
            fields.add(Pair.of((Object)"labelField", (Object)this.labelField));
        } else if (this.labels != null && this.labels.length > 0) {
            fields.add(Pair.of((Object)"labels", (Object)Arrays.toString(this.labels)));
        }
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
        this.labelField = null;
    }
}

