/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.ConfigValues;
import org.neo4j.kernel.configuration.Group;

public class GroupSettingSupport {
    private final String groupName;
    public final String groupKey;

    public static Function<ConfigValues, Stream<String>> enumerate(Class<?> settingsGroup) {
        Pattern pattern = Pattern.compile(Pattern.quote(GroupSettingSupport.groupPrefix(settingsGroup)) + "\\.([^\\.]+)\\.(.+)");
        return values -> values.rawConfiguration().stream().map(entry -> pattern.matcher((CharSequence)entry.first())).filter(Matcher::matches).map(match -> match.group(1)).distinct().sorted();
    }

    private static String groupPrefix(Class<?> groupClass) {
        return groupClass.getAnnotation(Group.class).value();
    }

    public GroupSettingSupport(Class<?> groupClass, String groupKey) {
        this(GroupSettingSupport.groupPrefix(groupClass), groupKey);
    }

    private GroupSettingSupport(String groupPrefix, String groupKey) {
        this.groupKey = groupKey;
        this.groupName = String.format("%s.%s", groupPrefix, groupKey);
    }

    public <T> Setting<T> scope(Setting<T> setting) {
        setting.withScope(key -> String.format("%s.%s", this.groupName, key));
        return setting;
    }
}

