/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.csv.Deserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;

public abstract class InputEntityDeserialization<ENTITY extends InputEntity>
implements Deserialization<ENTITY> {
    protected final SourceTraceability source;
    private Object[] properties = new Object[20];
    private int propertiesCursor;

    public InputEntityDeserialization(SourceTraceability source) {
        this.source = source;
    }

    public void addProperty(String name, Object value) {
        if (value != null) {
            this.ensurePropertiesArrayCapacity(this.propertiesCursor + 2);
            this.properties[this.propertiesCursor++] = name;
            this.properties[this.propertiesCursor++] = value;
        }
    }

    protected Object[] properties() {
        return this.propertiesCursor > 0 ? Arrays.copyOf(this.properties, this.propertiesCursor) : InputEntity.NO_PROPERTIES;
    }

    @Override
    public void handle(Header.Entry entry, Object value) {
        switch (entry.type()) {
            case PROPERTY: {
                if (value != null && value.getClass().isArray() && Array.getLength(value) == 0) break;
                this.addProperty(entry.name(), value);
                break;
            }
            case IGNORE: {
                break;
            }
        }
    }

    private void ensurePropertiesArrayCapacity(int length) {
        if (length > this.properties.length) {
            this.properties = Arrays.copyOf(this.properties, length);
        }
    }

    @Override
    public void clear() {
        this.propertiesCursor = 0;
    }
}

