/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.executor.DynamicTaskExecutor;
import org.neo4j.unsafe.impl.batchimport.executor.ParkStrategy;
import org.neo4j.unsafe.impl.batchimport.executor.TaskExecutor;
import org.neo4j.unsafe.impl.batchimport.staging.AbstractStep;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Processing;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public abstract class ProcessorStep<T>
extends AbstractStep<T> {
    private TaskExecutor<Sender> executor;
    private final int maxProcessors;
    private final Configuration config;
    private final AtomicLong lastBatchEndTime = new AtomicLong();
    private final ParkStrategy park = new ParkStrategy.Park(1L, TimeUnit.MILLISECONDS);

    protected ProcessorStep(StageControl control, String name, Configuration config, int maxProcessors, StatsProvider ... additionalStatsProviders) {
        super(control, name, config, additionalStatsProviders);
        this.config = config;
        this.maxProcessors = maxProcessors;
    }

    @Override
    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees);
        this.executor = new DynamicTaskExecutor<Sender>(1, this.maxProcessors, this.config.maxNumberOfProcessors(), DynamicTaskExecutor.DEFAULT_PARK_STRATEGY, this.name(), () -> new Sender());
    }

    @Override
    public long receive(long ticket, T batch) {
        this.incrementQueue();
        long nanoTime = System.nanoTime();
        this.executor.submit(sender -> {
            this.assertHealthy();
            sender.initialize(ticket);
            try {
                long startTime = System.nanoTime();
                this.process(batch, (BatchSender)sender);
                if (this.downstream == null) {
                    this.doneBatches.incrementAndGet();
                }
                this.totalProcessingTime.add(System.nanoTime() - startTime - ((Sender)sender).sendTime);
                this.decrementQueue();
                this.checkNotifyEndDownstream();
            }
            catch (Throwable e) {
                this.issuePanic(e);
            }
        });
        return System.nanoTime() - nanoTime;
    }

    private void decrementQueue() {
        int queueSizeAfterThisJobDone = this.queuedBatches.decrementAndGet();
        assert (queueSizeAfterThisJobDone >= 0) : "Negative queue size " + queueSizeAfterThisJobDone;
        if (queueSizeAfterThisJobDone == 0) {
            this.lastBatchEndTime.set(System.currentTimeMillis());
        }
    }

    private void incrementQueue() {
        long lastBatchEnd;
        if (this.queuedBatches.getAndIncrement() == 0 && (lastBatchEnd = this.lastBatchEndTime.get()) != 0L) {
            this.upstreamIdleTime.addAndGet(System.currentTimeMillis() - lastBatchEnd);
        }
    }

    protected abstract void process(T var1, BatchSender var2) throws Throwable;

    @Override
    public void close() throws Exception {
        super.close();
        this.executor.close();
    }

    @Override
    public int processors(int delta) {
        return this.executor.processors(delta);
    }

    private void sendDownstream(long ticket, Object batch) {
        if (this.guarantees(1)) {
            Processing.await(this.rightDoneTicket, ticket, this.healthChecker, this.park);
        }
        this.downstreamIdleTime.addAndGet(this.downstream.receive(ticket, batch));
        this.doneBatches.incrementAndGet();
    }

    @Override
    protected void done() {
        this.lastCallForEmittingOutstandingBatches(new Sender());
        super.done();
    }

    protected void lastCallForEmittingOutstandingBatches(BatchSender sender) {
    }

    private class Sender
    implements BatchSender {
        private long sendTime;
        private long ticket;

        private Sender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Object batch) {
            long time = System.nanoTime();
            try {
                ProcessorStep.this.sendDownstream(this.ticket, batch);
            }
            finally {
                this.sendTime += System.nanoTime() - time;
            }
        }

        public void initialize(long ticket) {
            this.ticket = ticket;
            this.sendTime = 0L;
        }
    }
}

