/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;

public class ReadOnlyIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, IdGenerator> idGenerators = new HashMap<IdType, IdGenerator>();

    @Override
    public IdGenerator open(File filename, IdType idType, long highId, long maxId) {
        return this.open(filename, 0, idType, highId, maxId);
    }

    @Override
    public IdGenerator open(File filename, int grabSize, IdType idType, long highId, long maxId) {
        ReadOnlyIdGenerator generator = new ReadOnlyIdGenerator(highId);
        this.idGenerators.put(idType, generator);
        return generator;
    }

    @Override
    public void create(File filename, long highId, boolean throwIfFileExists) {
    }

    @Override
    public IdGenerator get(IdType idType) {
        return this.idGenerators.get((Object)idType);
    }

    class ReadOnlyIdGenerator
    implements IdGenerator {
        private final long highId;

        ReadOnlyIdGenerator(long highId) {
            this.highId = highId;
        }

        @Override
        public long nextId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdRange nextIdBatch(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHighId(long id) {
        }

        @Override
        public long getHighId() {
            return this.highId;
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.highId - 1L;
        }

        @Override
        public void freeId(long id) {
        }

        @Override
        public void close() {
        }

        @Override
        public long getNumberOfIdsInUse() {
            return 0L;
        }

        @Override
        public long getDefragCount() {
            return 0L;
        }

        @Override
        public void delete() {
        }
    }
}

