/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.time.Clock;
import java.util.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.DefaultPropertyTokenCreator;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.DelegatingLabelTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingPropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingRelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.factory.ReadOnly;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocksFactory;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.DefaultKernelData;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.udc.UsageData;

public class CommunityEditionModule
extends EditionModule {
    public static final String COMMUNITY_SECURITY_MODULE_ID = "community-security-module";

    public CommunityEditionModule(PlatformModule platformModule) {
        Dependencies dependencies = platformModule.dependencies;
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        PageCache pageCache = platformModule.pageCache;
        File storeDir = platformModule.storeDir;
        DataSourceManager dataSourceManager = platformModule.dataSourceManager;
        LifeSupport life = platformModule.life;
        life.add((Lifecycle)platformModule.dataSourceManager);
        this.watcherService = this.createFileSystemWatcherService(fileSystem, storeDir, logging, platformModule.jobScheduler, CommunityEditionModule.fileWatcherFileNameFilter());
        dependencies.satisfyDependencies(this.watcherService);
        life.add((Lifecycle)this.watcherService);
        this.accessCapability = config.get(GraphDatabaseSettings.read_only) != false ? new ReadOnly() : new CanWrite();
        GraphDatabaseFacade graphDatabaseFacade = platformModule.graphDatabaseFacade;
        this.lockManager = dependencies.satisfyDependency(CommunityEditionModule.createLockManager(config, (Clock)platformModule.clock, logging));
        this.statementLocksFactory = this.createStatementLocksFactory(this.lockManager, config, logging);
        this.idTypeConfigurationProvider = this.createIdTypeConfigurationProvider(config);
        this.idGeneratorFactory = dependencies.satisfyDependency(this.createIdGeneratorFactory(fileSystem, this.idTypeConfigurationProvider));
        this.propertyKeyTokenHolder = (PropertyKeyTokenHolder)life.add((Lifecycle)dependencies.satisfyDependency(new DelegatingPropertyKeyTokenHolder(this.createPropertyKeyCreator(config, dataSourceManager, this.idGeneratorFactory))));
        this.labelTokenHolder = (LabelTokenHolder)life.add((Lifecycle)dependencies.satisfyDependency(new DelegatingLabelTokenHolder(this.createLabelIdCreator(config, dataSourceManager, this.idGeneratorFactory))));
        this.relationshipTypeTokenHolder = (RelationshipTypeTokenHolder)life.add((Lifecycle)dependencies.satisfyDependency(new DelegatingRelationshipTypeTokenHolder(this.createRelationshipTypeCreator(config, dataSourceManager, this.idGeneratorFactory))));
        dependencies.satisfyDependency(this.createKernelData(fileSystem, pageCache, storeDir, config, graphDatabaseFacade, life));
        this.commitProcessFactory = new CommunityCommitProcessFactory();
        this.headerInformationFactory = this.createHeaderInformationFactory();
        this.schemaWriteGuard = this.createSchemaWriteGuard();
        this.transactionStartTimeout = config.get(GraphDatabaseSettings.transaction_start_timeout);
        this.constraintSemantics = this.createSchemaRuleVerifier();
        this.coreAPIAvailabilityGuard = new CoreAPIAvailabilityGuard(platformModule.availabilityGuard, this.transactionStartTimeout);
        this.ioLimiter = IOLimiter.unlimited();
        this.eligibleForIdReuse = IdReuseEligibility.ALWAYS;
        this.registerRecovery(platformModule.databaseInfo, life, (DependencyResolver)dependencies);
        this.publishEditionInfo((UsageData)((Object)dependencies.resolveDependency(UsageData.class)), platformModule.databaseInfo, config);
        dependencies.satisfyDependency(this.createSessionTracker());
    }

    static Predicate<String> fileWatcherFileNameFilter() {
        return Predicates.any((Predicate[])new Predicate[]{fileName -> fileName.startsWith("neostore.transaction.db"), fileName -> fileName.startsWith("index.db")});
    }

    protected IdTypeConfigurationProvider createIdTypeConfigurationProvider(Config config) {
        return new CommunityIdTypeConfigurationProvider();
    }

    protected ConstraintSemantics createSchemaRuleVerifier() {
        return new StandardConstraintSemantics();
    }

    protected StatementLocksFactory createStatementLocksFactory(Locks locks, Config config, LogService logService) {
        return new SimpleStatementLocksFactory(locks);
    }

    protected SchemaWriteGuard createSchemaWriteGuard() {
        return () -> {};
    }

    private TokenCreator createRelationshipTypeCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultRelationshipTypeCreator(dataSourceManager, idGeneratorFactory);
    }

    private TokenCreator createPropertyKeyCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultPropertyTokenCreator(dataSourceManager, idGeneratorFactory);
    }

    private TokenCreator createLabelIdCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultLabelIdCreator(dataSourceManager, idGeneratorFactory);
    }

    private KernelData createKernelData(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, Config config, GraphDatabaseAPI graphAPI, LifeSupport life) {
        return (KernelData)life.add((Lifecycle)new DefaultKernelData(fileSystem, pageCache, storeDir, config, graphAPI));
    }

    protected IdGeneratorFactory createIdGeneratorFactory(FileSystemAbstraction fs, IdTypeConfigurationProvider idTypeConfigurationProvider) {
        return new DefaultIdGeneratorFactory(fs, idTypeConfigurationProvider);
    }

    public static Locks createLockManager(Config config, Clock clock, LogService logging) {
        String key = config.get(GraphDatabaseFacadeFactory.Configuration.lock_manager);
        for (Locks.Factory candidate : Service.load(Locks.Factory.class)) {
            String candidateId = candidate.getKeys().iterator().next();
            if (key.equals(candidateId)) {
                return candidate.newInstance(config, clock, ResourceTypes.values());
            }
            if (!key.equals("")) continue;
            logging.getInternalLog(CommunityEditionModule.class).info("No locking implementation specified, defaulting to '" + candidateId + "'");
            return candidate.newInstance(config, clock, ResourceTypes.values());
        }
        if (key.equals("community")) {
            return new CommunityLockManger(config, clock);
        }
        if (key.equals("")) {
            logging.getInternalLog(CommunityEditionModule.class).info("No locking implementation specified, defaulting to 'community'");
            return new CommunityLockManger(config, clock);
        }
        throw new IllegalArgumentException("No lock manager found with the name '" + key + "'.");
    }

    protected TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return TransactionHeaderInformationFactory.DEFAULT;
    }

    private void registerRecovery(DatabaseInfo databaseInfo, LifeSupport life, DependencyResolver dependencyResolver) {
        life.addLifecycleListener((instance, from, to) -> {
            if (instance instanceof DatabaseAvailability && to.equals((Object)LifecycleStatus.STARTED)) {
                this.doAfterRecoveryAndStartup(databaseInfo, dependencyResolver);
            }
        });
    }

    @Override
    public void registerEditionSpecificProcedures(Procedures procedures) throws KernelException {
    }

    @Override
    protected void doAfterRecoveryAndStartup(DatabaseInfo databaseInfo, DependencyResolver dependencyResolver) {
        super.doAfterRecoveryAndStartup(databaseInfo, dependencyResolver);
        new RemoveOrphanConstraintIndexesOnStartup(((NeoStoreDataSource)dependencyResolver.resolveDependency(NeoStoreDataSource.class)).getKernel(), ((LogService)dependencyResolver.resolveDependency(LogService.class)).getInternalLogProvider()).perform();
    }

    @Override
    public void setupSecurityModule(PlatformModule platformModule, Procedures procedures) {
        if (platformModule.config.get(GraphDatabaseSettings.auth_enabled).booleanValue()) {
            CommunityEditionModule.setupSecurityModule(platformModule, platformModule.logging.getUserLog(this.getClass()), procedures, COMMUNITY_SECURITY_MODULE_ID);
        } else {
            platformModule.life.add((Lifecycle)platformModule.dependencies.satisfyDependency(AuthManager.NO_AUTH));
            platformModule.life.add((Lifecycle)platformModule.dependencies.satisfyDependency(UserManagerSupplier.NO_AUTH));
        }
    }
}

