/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new;

import java.util.Arrays;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema_new.SchemaComputer;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaProcessor;
import org.neo4j.kernel.api.schema_new.SchemaUtil;

public class LabelSchemaDescriptor
implements SchemaDescriptor,
LabelSchemaSupplier {
    private final int labelId;
    private final int[] propertyIds;

    public LabelSchemaDescriptor(int labelId, int ... propertyIds) {
        this.labelId = labelId;
        this.propertyIds = propertyIds;
    }

    @Override
    public <R> R computeWith(SchemaComputer<R> processor) {
        return processor.computeSpecific(this);
    }

    @Override
    public void processWith(SchemaProcessor processor) {
        processor.processSpecific(this);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format(":%s(%s)", tokenNameLookup.labelGetName(this.labelId), SchemaUtil.niceProperties(tokenNameLookup, this.propertyIds));
    }

    public int getLabelId() {
        return this.labelId;
    }

    @Override
    public int[] getPropertyIds() {
        return this.propertyIds;
    }

    public int getPropertyId() {
        if (this.propertyIds.length != 1) {
            throw new IllegalStateException("Single property schema requires one property but had " + this.propertyIds.length);
        }
        return this.propertyIds[0];
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof LabelSchemaDescriptor) {
            LabelSchemaDescriptor that = (LabelSchemaDescriptor)o;
            return this.labelId == that.getLabelId() && Arrays.equals(this.propertyIds, that.getPropertyIds());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.propertyIds) + 31 * this.labelId;
    }

    public String toString() {
        return "LabelSchemaDescriptor( " + this.userDescription(SchemaUtil.idTokenNameLookup) + " )";
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this;
    }
}

