/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.labelscan.CompositeLabelScanValueIterator;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIterator;
import org.neo4j.storageengine.api.schema.LabelScanReader;

class NativeLabelScanReader
implements LabelScanReader {
    private final GBPTree<LabelScanKey, LabelScanValue> index;
    private final Queue<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> openCursors;

    NativeLabelScanReader(GBPTree<LabelScanKey, LabelScanValue> index) {
        this.index = index;
        this.openCursors = new LinkedList<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>>();
    }

    public void close() {
        try {
            this.ensureOpenCursorsClosed();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public PrimitiveLongIterator nodesWithLabel(int labelId) {
        RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor;
        try {
            this.ensureOpenCursorsClosed();
            cursor = this.seekerForLabel(labelId);
            this.openCursors.offer(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new LabelScanValueIterator(cursor);
    }

    @Override
    public PrimitiveLongIterator nodesWithAnyOfLabels(int ... labelIds) {
        List<PrimitiveLongIterator> iterators = this.iteratorsForLabels(labelIds);
        return new CompositeLabelScanValueIterator(iterators, false);
    }

    @Override
    public PrimitiveLongIterator nodesWithAllLabels(int ... labelIds) {
        List<PrimitiveLongIterator> iterators = this.iteratorsForLabels(labelIds);
        return new CompositeLabelScanValueIterator(iterators, true);
    }

    private List<PrimitiveLongIterator> iteratorsForLabels(int[] labelIds) {
        ArrayList<PrimitiveLongIterator> iterators = new ArrayList<PrimitiveLongIterator>();
        try {
            this.ensureOpenCursorsClosed();
            for (int labelId : labelIds) {
                RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor = this.seekerForLabel(labelId);
                this.openCursors.offer(cursor);
                iterators.add((PrimitiveLongIterator)new LabelScanValueIterator(cursor));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return iterators;
    }

    private RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> seekerForLabel(int labelId) throws IOException {
        LabelScanKey from = new LabelScanKey(labelId, 0L);
        LabelScanKey to = new LabelScanKey(labelId, Long.MAX_VALUE);
        return this.index.seek((Object)from, (Object)to);
    }

    private void ensureOpenCursorsClosed() throws IOException {
        RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor;
        while ((cursor = this.openCursors.poll()) != null) {
            cursor.close();
        }
    }
}

