/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public final class IndexMap
implements Cloneable {
    private final Map<Long, IndexProxy> indexesById;
    private final Map<LabelSchemaDescriptor, IndexProxy> indexesByDescriptor;
    private final Map<LabelSchemaDescriptor, Long> indexIdsByDescriptor;

    public IndexMap() {
        this(new HashMap<Long, IndexProxy>(), new HashMap<LabelSchemaDescriptor, IndexProxy>(), new HashMap<LabelSchemaDescriptor, Long>());
    }

    private IndexMap(Map<Long, IndexProxy> indexesById, Map<LabelSchemaDescriptor, IndexProxy> indexesByDescriptor, Map<LabelSchemaDescriptor, Long> indexIdsByDescriptor) {
        this.indexesById = indexesById;
        this.indexesByDescriptor = indexesByDescriptor;
        this.indexIdsByDescriptor = indexIdsByDescriptor;
    }

    public IndexProxy getIndexProxy(long indexId) {
        return this.indexesById.get(indexId);
    }

    public IndexProxy getIndexProxy(LabelSchemaDescriptor descriptor) {
        return this.indexesByDescriptor.get(descriptor);
    }

    public long getIndexId(LabelSchemaDescriptor descriptor) {
        return this.indexIdsByDescriptor.get(descriptor);
    }

    public void putIndexProxy(long indexId, IndexProxy indexProxy) {
        this.indexesById.put(indexId, indexProxy);
        this.indexesByDescriptor.put(indexProxy.getDescriptor().schema(), indexProxy);
        this.indexIdsByDescriptor.put(indexProxy.getDescriptor().schema(), indexId);
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexProxy removedProxy = this.indexesById.remove(indexId);
        if (null != removedProxy) {
            this.indexesByDescriptor.remove(removedProxy.getDescriptor().schema());
        }
        return removedProxy;
    }

    public void foreachIndexProxy(BiConsumer<Long, IndexProxy> consumer) {
        for (Map.Entry<Long, IndexProxy> entry : this.indexesById.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    public IndexMap clone() {
        return new IndexMap(this.cloneMap(this.indexesById), this.cloneMap(this.indexesByDescriptor), this.cloneMap(this.indexIdsByDescriptor));
    }

    private <K, V> Map<K, V> cloneMap(Map<K, V> map) {
        HashMap<K, V> shallowCopy = new HashMap<K, V>(map.size());
        shallowCopy.putAll(map);
        return shallowCopy;
    }

    public Iterator<LabelSchemaDescriptor> descriptors() {
        return this.indexesByDescriptor.keySet().iterator();
    }

    public Iterator<Long> indexIds() {
        return this.indexesById.keySet().iterator();
    }

    public int size() {
        return this.indexesById.size();
    }
}

