/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.Future;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public abstract class AbstractSwallowingIndexProxy
implements IndexProxy {
    private final NewIndexDescriptor descriptor;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final IndexPopulationFailure populationFailure;

    public AbstractSwallowingIndexProxy(NewIndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, IndexPopulationFailure populationFailure) {
        this.descriptor = descriptor;
        this.providerDescriptor = providerDescriptor;
        this.populationFailure = populationFailure;
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() {
        return this.populationFailure;
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.NONE;
    }

    @Override
    public void start() {
        String message = "Unable to start index, it is in a " + this.getState().name() + " state.";
        throw new UnsupportedOperationException(message + ", caused by: " + this.getPopulationFailure());
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return SwallowingIndexUpdater.INSTANCE;
    }

    @Override
    public void force() {
    }

    @Override
    public void flush() {
    }

    @Override
    public NewIndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.descriptor.schema();
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public Future<Void> close() {
        return FutureAdapter.VOID;
    }

    @Override
    public IndexReader newReader() {
        throw new UnsupportedOperationException();
    }
}

