/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.constaints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema_new.SchemaUtil;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;

public abstract class IndexBackedConstraintDescriptor
extends ConstraintDescriptor
implements LabelSchemaSupplier {
    private final LabelSchemaDescriptor schema;

    IndexBackedConstraintDescriptor(ConstraintDescriptor.Type type, LabelSchemaDescriptor schema) {
        super(type);
        this.schema = schema;
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    public NewIndexDescriptor ownedIndexDescriptor() {
        return NewIndexDescriptorFactory.uniqueForSchema(this.schema);
    }

    @Override
    public String prettyPrint(TokenNameLookup tokenNameLookup) {
        String labelName = this.escapeLabelOrRelTyp(tokenNameLookup.labelGetName(this.schema.getLabelId()));
        String nodeName = labelName.toLowerCase();
        String properties = SchemaUtil.niceProperties(tokenNameLookup, this.schema.getPropertyIds(), nodeName + ".", this.schema().getPropertyIds().length > 1);
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s IS %s", nodeName, labelName, properties, this.constraintTypeText());
    }

    protected abstract String constraintTypeText();
}

