/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.ArrayValue;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.FloatingPointArrayProperty;

abstract class IntegralArrayProperty
extends DefinedProperty
implements ArrayValue.IntegralArray {
    IntegralArrayProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    @Override
    public abstract int length();

    @Override
    public abstract long longValue(int var1);

    @Override
    public final int valueHash() {
        return IntegralArrayProperty.hash(this);
    }

    static int hash(ArrayValue.IntegralArray value) {
        int result = 1;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            long element = value.longValue(i);
            int elementHash = (int)(element ^ element >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }

    @Override
    public final boolean valueEquals(Object other) {
        return IntegralArrayProperty.valueEquals(this, other);
    }

    static boolean valueEquals(ArrayValue.IntegralArray value, Object other) {
        if (other instanceof long[]) {
            return IntegralArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.LongArray((long[])other));
        }
        if (other instanceof int[]) {
            return IntegralArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.IntArray((int[])other));
        }
        if (other instanceof short[]) {
            return IntegralArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.ShortArray((short[])other));
        }
        if (other instanceof byte[]) {
            return IntegralArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.ByteArray((byte[])other));
        }
        if (other instanceof Number[]) {
            Number[] that = (Number[])other;
            if (that.length == value.length()) {
                if (other instanceof Double[] || other instanceof Float[]) {
                    return IntegralArrayProperty.numbersEqual(ArrayValue.NumberArray.asFloatingPoint(that), value);
                }
                return IntegralArrayProperty.numbersEqual(value, ArrayValue.NumberArray.asIntegral(that));
            }
        } else {
            if (other instanceof double[]) {
                return IntegralArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)new ArrayValue.DoubleArray((double[])other), value);
            }
            if (other instanceof float[]) {
                return IntegralArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)new ArrayValue.FloatArray((float[])other), value);
            }
        }
        return false;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty other) {
        if (other instanceof IntegralArrayProperty) {
            IntegralArrayProperty that = (IntegralArrayProperty)other;
            return IntegralArrayProperty.numbersEqual(this, (ArrayValue.IntegralArray)that);
        }
        if (other instanceof FloatingPointArrayProperty) {
            FloatingPointArrayProperty that = (FloatingPointArrayProperty)other;
            return IntegralArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)that, (ArrayValue.IntegralArray)this);
        }
        return false;
    }
}

