/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.labelscan;

import java.util.Map;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.logging.Log;

public class LoggingMonitor
implements LabelScanStore.Monitor {
    private final Log log;
    private final LabelScanStore.Monitor delegate;

    public LoggingMonitor(Log log) {
        this(log, LabelScanStore.Monitor.EMPTY);
    }

    public LoggingMonitor(Log log, LabelScanStore.Monitor delegate) {
        this.log = log;
        this.delegate = delegate;
    }

    @Override
    public void init() {
        this.delegate.init();
    }

    @Override
    public void noIndex() {
        this.log.info("No scan store found, this might just be first use. Preparing to rebuild.");
        this.delegate.noIndex();
    }

    @Override
    public void lockedIndex(Exception e) {
        this.log.error("Scan store is locked by another process or database", (Throwable)e);
        this.delegate.lockedIndex(e);
    }

    @Override
    public void notValidIndex() {
        this.log.warn("Scan store could not be read. Preparing to rebuild.");
        this.delegate.notValidIndex();
    }

    @Override
    public void rebuilding() {
        this.log.info("Rebuilding scan store, this may take a while");
        this.delegate.rebuilding();
    }

    @Override
    public void rebuilt(long roughNodeCount) {
        this.log.info("Scan store rebuilt (roughly " + roughNodeCount + " nodes)");
        this.delegate.rebuilt(roughNodeCount);
    }

    @Override
    public void recoveryCompleted(Map<String, Object> data) {
        StringBuilder builder = new StringBuilder("Scan store recovery completed:");
        data.forEach((key, value) -> builder.append(String.format(" %s: %s", key, value)));
        this.log.info(builder.toString());
        this.delegate.recoveryCompleted(data);
    }
}

