/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.index.NodeUpdates;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;

public class OnlineIndexUpdates
implements IndexUpdates {
    private final NodeStore nodeStore;
    private final PropertyLoader propertyLoader;
    private final PropertyPhysicalToLogicalConverter converter;
    private final Collection<NodeUpdates> updates = new ArrayList<NodeUpdates>();
    private NodeRecord nodeRecord;

    public OnlineIndexUpdates(NodeStore nodeStore, PropertyLoader propertyLoader, PropertyPhysicalToLogicalConverter converter) {
        this.nodeStore = nodeStore;
        this.propertyLoader = propertyLoader;
        this.converter = converter;
    }

    @Override
    public Iterator<NodeUpdates> iterator() {
        return this.updates.iterator();
    }

    @Override
    public void collectUpdatedNodeIds(PrimitiveLongSet target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void feed(PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommands, PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands) {
        for (long nodeId : this.allKeys(nodeCommands, propertyCommands)) {
            this.gatherUpdatesFor(nodeId, (Command.NodeCommand)nodeCommands.get(nodeId), (List)propertyCommands.get(nodeId));
        }
    }

    private PrimitiveLongSet allKeys(PrimitiveLongObjectMap ... maps) {
        PrimitiveLongSet union = Primitive.longSet();
        for (PrimitiveLongObjectMap map : maps) {
            union.addAll(map.iterator());
        }
        return union;
    }

    @Override
    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    private void gatherUpdatesFor(long nodeId, Command.NodeCommand nodeCommand, List<Command.PropertyCommand> propertyCommands) {
        NodeUpdates.Builder nodePropertyUpdate = this.gatherUpdatesFromCommandsForNode(nodeId, nodeCommand, propertyCommands);
        if (nodePropertyUpdate.hasUpdatedLabels() || nodePropertyUpdate.hasUpdates()) {
            Stream properties = Iterators.stream(this.nodeFullyLoadProperties(nodeId, nodeCommand, propertyCommands));
            DefinedProperty[] definedProperties = (DefinedProperty[])properties.toArray(DefinedProperty[]::new);
            this.updates.add(nodePropertyUpdate.buildWithExistingProperties(definedProperties));
        }
    }

    private NodeUpdates.Builder gatherUpdatesFromCommandsForNode(long nodeId, Command.NodeCommand nodeChanges, List<Command.PropertyCommand> propertyCommandsForNode) {
        long[] nodeLabelsAfter;
        long[] nodeLabelsBefore;
        if (nodeChanges != null) {
            nodeLabelsBefore = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getBefore()).get(this.nodeStore);
            nodeLabelsAfter = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getAfter()).get(this.nodeStore);
        } else {
            NodeRecord nodeRecord = this.loadNode(nodeId);
            nodeLabelsBefore = nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeRecord).get(this.nodeStore);
        }
        NodeUpdates.Builder nodePropertyUpdates = NodeUpdates.forNode(nodeId, nodeLabelsBefore, nodeLabelsAfter);
        if (propertyCommandsForNode != null) {
            this.converter.convertPropertyRecord(nodeId, Iterables.cast(propertyCommandsForNode), nodePropertyUpdates);
        }
        return nodePropertyUpdates;
    }

    private NodeRecord loadNode(long nodeId) {
        if (this.nodeRecord == null) {
            this.nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        }
        this.nodeStore.getRecord(nodeId, this.nodeRecord, RecordLoad.NORMAL);
        return this.nodeRecord;
    }

    private Iterator<DefinedProperty> nodeFullyLoadProperties(long nodeId, Command.NodeCommand nodeCommand, List<Command.PropertyCommand> propertyCommands) {
        NodeRecord nodeRecord = nodeCommand == null ? this.loadNode(nodeId) : (NodeRecord)nodeCommand.getAfter();
        IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
        PrimitiveLongObjectMap<PropertyRecord> propertiesById = this.propertiesFromCommandsForNode(propertyCommands);
        this.propertyLoader.nodeLoadProperties(nodeRecord, propertiesById, receiver);
        return receiver;
    }

    private PrimitiveLongObjectMap<PropertyRecord> propertiesFromCommandsForNode(List<Command.PropertyCommand> propertyCommands) {
        if (propertyCommands == null) {
            return PrimitiveLongCollections.emptyObjectMap();
        }
        PrimitiveLongObjectMap result = Primitive.longObjectMap((int)propertyCommands.size());
        for (Command.PropertyCommand command : propertyCommands) {
            PropertyRecord after = (PropertyRecord)command.getAfter();
            if (!after.inUse() || !after.isNodeSet()) continue;
            result.put(after.getId(), (Object)after);
        }
        return result;
    }
}

