/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.kernel.impl.store.record.TokenRecord;

public class PropertyKeyTokenRecord
extends TokenRecord {
    private int propCount;

    public PropertyKeyTokenRecord(int id) {
        super(id);
    }

    public PropertyKeyTokenRecord initialize(boolean inUse, int nameId, int propertyCount) {
        super.initialize(inUse, nameId);
        this.propCount = propertyCount;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.propCount = 0;
    }

    @Override
    protected String simpleName() {
        return "PropertyKey";
    }

    public int getPropertyCount() {
        return this.propCount;
    }

    public void setPropertyCount(int count) {
        this.propCount = count;
    }

    @Override
    protected void additionalToString(StringBuilder buf) {
        buf.append(",propCount=").append(this.propCount);
    }

    @Override
    public PropertyKeyTokenRecord clone() {
        PropertyKeyTokenRecord propertyKeyTokenRecord = new PropertyKeyTokenRecord(this.getIntId());
        propertyKeyTokenRecord.setInUse(this.inUse());
        if (this.isCreated()) {
            propertyKeyTokenRecord.setCreated();
        }
        propertyKeyTokenRecord.setNameId(this.getNameId());
        propertyKeyTokenRecord.addNameRecords(this.getNameRecords());
        propertyKeyTokenRecord.setPropertyCount(this.getPropertyCount());
        return propertyKeyTokenRecord;
    }
}

