/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.UnknownKey;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

class KeyFormat
implements CountsVisitor {
    private static final byte NODE_COUNT = 1;
    private static final byte RELATIONSHIP_COUNT = 2;
    private static final byte INDEX = 127;
    private static final byte INDEX_STATS = 1;
    private static final byte INDEX_SAMPLE = 2;
    private final WritableBuffer buffer;

    public KeyFormat(WritableBuffer key) {
        assert (key.size() >= 16);
        this.buffer = key;
    }

    @Override
    public void visitNodeCount(int labelId, long count) {
        this.buffer.putByte(0, (byte)1).putInt(12, labelId);
    }

    @Override
    public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
        this.buffer.putByte(0, (byte)2).putInt(4, startLabelId).putInt(8, typeId).putInt(12, endLabelId);
    }

    @Override
    public void visitIndexStatistics(long indexId, long updates, long size) {
        this.indexKey((byte)1, indexId);
    }

    @Override
    public void visitIndexSample(long indexId, long unique, long size) {
        this.indexKey((byte)2, indexId);
    }

    private void indexKey(byte indexKey, long indexId) {
        this.buffer.putByte(0, (byte)127).putInt(4, (int)indexId).putByte(15, indexKey);
    }

    public static CountsKey readKey(ReadableBuffer key) throws UnknownKey {
        switch (key.getByte(0)) {
            case 1: {
                return CountsKeyFactory.nodeKey(key.getInt(12));
            }
            case 2: {
                return CountsKeyFactory.relationshipKey(key.getInt(4), key.getInt(8), key.getInt(12));
            }
            case 127: {
                byte indexKeyByte = key.getByte(15);
                long indexId = key.getInt(4);
                switch (indexKeyByte) {
                    case 1: {
                        return CountsKeyFactory.indexStatisticsKey(indexId);
                    }
                    case 2: {
                        return CountsKeyFactory.indexSampleKey(indexId);
                    }
                }
                throw new IllegalStateException("Unknown index key: " + indexKeyByte);
            }
        }
        throw new UnknownKey("Unknown key type: " + key);
    }
}

