/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.storageengine.api.schema.IndexReader;

public interface IndexReaderFactory {
    public IndexReader newReader(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public IndexReader newUnCachedReader(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public void close();

    public static class Caching
    implements IndexReaderFactory {
        private Map<IndexDescriptor, IndexReader> indexReaders;
        private final IndexingService indexingService;

        public Caching(IndexingService indexingService) {
            this.indexingService = indexingService;
        }

        @Override
        public IndexReader newReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
            IndexReader reader;
            if (this.indexReaders == null) {
                this.indexReaders = new HashMap<IndexDescriptor, IndexReader>();
            }
            if ((reader = this.indexReaders.get(descriptor)) == null) {
                reader = this.newUnCachedReader(descriptor);
                this.indexReaders.put(descriptor, reader);
            }
            return reader;
        }

        @Override
        public IndexReader newUnCachedReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
            IndexProxy index = this.indexingService.getIndexProxy(descriptor);
            return index.newReader();
        }

        @Override
        public void close() {
            if (this.indexReaders != null) {
                for (IndexReader indexReader : this.indexReaders.values()) {
                    indexReader.close();
                }
                this.indexReaders.clear();
            }
        }
    }
}

