/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.index;

import java.util.Iterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;

public class IndexBoundary {
    public static IndexDescriptor map(NewIndexDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return IndexDescriptorFactory.of(descriptor.schema().getLabelId(), descriptor.schema().getPropertyIds());
    }

    public static IndexDescriptor map(LabelSchemaDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return IndexDescriptorFactory.of(descriptor.getLabelId(), descriptor.getPropertyIds());
    }

    public static NewIndexDescriptor map(IndexDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.isComposite()) {
            return NewIndexDescriptorFactory.forLabel(descriptor.getLabelId(), descriptor.getPropertyKeyIds());
        }
        return NewIndexDescriptorFactory.forLabel(descriptor.getLabelId(), descriptor.getPropertyKeyId());
    }

    public static NewIndexDescriptor map(NodePropertyDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return NewIndexDescriptorFactory.forLabel(descriptor.getLabelId(), descriptor.getPropertyKeyId());
    }

    public static NewIndexDescriptor mapUnique(IndexDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return NewIndexDescriptorFactory.uniqueForLabel(descriptor.getLabelId(), descriptor.getPropertyKeyId());
    }

    public static Iterator<IndexDescriptor> map(Iterator<NewIndexDescriptor> iterator) {
        return Iterators.map(IndexBoundary::map, iterator);
    }
}

