/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.constaints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;

public class UniquenessConstraintDescriptor
extends ConstraintDescriptor {
    private final LabelSchemaDescriptor schema;

    UniquenessConstraintDescriptor(LabelSchemaDescriptor schema) {
        super(ConstraintDescriptor.Type.UNIQUE);
        this.schema = schema;
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    public NewIndexDescriptor ownedIndexDescriptor() {
        return NewIndexDescriptorFactory.uniqueForSchema(this.schema);
    }

    @Override
    public String prettyPrint(TokenNameLookup tokenNameLookup) {
        String labelName = this.escapeLabelOrRelTyp(tokenNameLookup.labelGetName(this.schema.getLabelId()));
        String nodeName = labelName.toLowerCase();
        String propertyName = tokenNameLookup.propertyKeyGetName(this.schema.getPropertyId());
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s.%s IS UNIQUE", nodeName, labelName, nodeName, propertyName);
    }
}

