/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class IndexQuery {
    private final int propertyKeyId;

    public static ExistsPredicate exists(int propertyKeyId) {
        return new ExistsPredicate(propertyKeyId);
    }

    public static ExactPredicate exact(int propertyKeyId, Object value) {
        return new ExactPredicate(propertyKeyId, value);
    }

    public static NumberRangePredicate range(int propertyKeyId, Number from, boolean fromInclusive, Number to, boolean toInclusive) {
        return new NumberRangePredicate(propertyKeyId, from, fromInclusive, to, toInclusive);
    }

    public static StringRangePredicate range(int propertyKeyId, String from, boolean fromInclusive, String to, boolean toInclusive) {
        return new StringRangePredicate(propertyKeyId, from, fromInclusive, to, toInclusive);
    }

    public static StringPrefixPredicate stringPrefix(int propertyKeyId, String prefix) {
        return new StringPrefixPredicate(propertyKeyId, prefix);
    }

    public static StringContainsPredicate stringContains(int propertyKeyId, String contains) {
        return new StringContainsPredicate(propertyKeyId, contains);
    }

    public static StringSuffixPredicate stringSuffix(int propertyKeyId, String suffix) {
        return new StringSuffixPredicate(propertyKeyId, suffix);
    }

    protected IndexQuery(int propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    public abstract IndexQueryType type();

    public final boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public final int propertyKeyId() {
        return this.propertyKeyId;
    }

    public static final class StringSuffixPredicate
    extends IndexQuery {
        private final String suffix;

        public StringSuffixPredicate(int propertyKeyId, String suffix) {
            super(propertyKeyId);
            this.suffix = suffix;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringSuffix;
        }

        public String suffix() {
            return this.suffix;
        }
    }

    public static final class StringContainsPredicate
    extends IndexQuery {
        private final String contains;

        public StringContainsPredicate(int propertyKeyId, String contains) {
            super(propertyKeyId);
            this.contains = contains;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringContains;
        }

        public String contains() {
            return this.contains;
        }
    }

    public static final class StringPrefixPredicate
    extends IndexQuery {
        private final String prefix;

        public StringPrefixPredicate(int propertyKeyId, String prefix) {
            super(propertyKeyId);
            this.prefix = prefix;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringPrefix;
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public static final class StringRangePredicate
    extends IndexQuery {
        private final String from;
        private final boolean fromInclusive;
        private final String to;
        private final boolean toInclusive;

        public StringRangePredicate(int propertyKeyId, String from, boolean fromInclusive, String to, boolean toInclusive) {
            super(propertyKeyId);
            this.from = from;
            this.fromInclusive = fromInclusive;
            this.to = to;
            this.toInclusive = toInclusive;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.rangeString;
        }

        public String from() {
            return this.from;
        }

        public boolean fromInclusive() {
            return this.fromInclusive;
        }

        public String to() {
            return this.to;
        }

        public boolean toInclusive() {
            return this.toInclusive;
        }
    }

    public static final class NumberRangePredicate
    extends IndexQuery {
        private final Number from;
        private final boolean fromInclusive;
        private final Number to;
        private final boolean toInclusive;

        public NumberRangePredicate(int propertyKeyId, Number from, boolean fromInclusive, Number to, boolean toInclusive) {
            super(propertyKeyId);
            this.from = from;
            this.fromInclusive = fromInclusive;
            this.to = to;
            this.toInclusive = toInclusive;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.rangeNumeric;
        }

        public Number from() {
            return this.from;
        }

        public Number to() {
            return this.to;
        }

        public boolean fromInclusive() {
            return this.fromInclusive;
        }

        public boolean toInclusive() {
            return this.toInclusive;
        }
    }

    public static final class ExactPredicate
    extends IndexQuery {
        private final Object value;

        public ExactPredicate(int propertyKeyId, Object value) {
            super(propertyKeyId);
            this.value = value;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.exact;
        }

        public Object value() {
            return this.value;
        }
    }

    public static final class ExistsPredicate
    extends IndexQuery {
        public ExistsPredicate(int propertyKeyId) {
            super(propertyKeyId);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.exists;
        }
    }

    public static enum IndexQueryType {
        exists,
        exact,
        rangeString,
        rangeNumeric,
        stringPrefix,
        stringSuffix,
        stringContains;

    }
}

