/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.schema.CompositeIndexDescriptor;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.NodeMultiPropertyDescriptor;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema.SinglePropertyIndexDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.PropertyNameUtils;
import org.neo4j.kernel.impl.store.record.IndexRule;

public class IndexDescriptorFactory {
    public static IndexDescriptor of(int labelId, int ... propertyKeyIds) {
        if (propertyKeyIds.length == 0) {
            throw new IllegalArgumentException("Index descriptors must contain at least one property");
        }
        if (propertyKeyIds.length == 1) {
            return new SinglePropertyIndexDescriptor(labelId, propertyKeyIds[0]);
        }
        return new CompositeIndexDescriptor(labelId, propertyKeyIds);
    }

    public static IndexDescriptor of(NodePropertyDescriptor descriptor) {
        return descriptor.isComposite() ? new CompositeIndexDescriptor(descriptor.getLabelId(), descriptor.getPropertyKeyIds()) : new SinglePropertyIndexDescriptor(descriptor.getLabelId(), descriptor.getPropertyKeyId());
    }

    public static IndexDescriptor of(IndexRule rule) {
        LabelSchemaDescriptor schema = rule.getIndexDescriptor().schema();
        return IndexDescriptorFactory.of(schema.getLabelId(), schema.getPropertyId());
    }

    public static NodePropertyDescriptor getNodePropertyDescriptor(int labelId, int[] propertyKeyIds) {
        return propertyKeyIds.length > 1 ? new NodeMultiPropertyDescriptor(labelId, propertyKeyIds) : new NodePropertyDescriptor(labelId, propertyKeyIds[0]);
    }

    public static NodePropertyDescriptor getNodePropertyDescriptor(int labelId, int propertyKeyId) {
        return new NodePropertyDescriptor(labelId, propertyKeyId);
    }

    public static NodePropertyDescriptor getOrCreateTokens(TokenWriteOperations schemaWriteOperations, IndexDefinition indexDefinition) throws IllegalTokenNameException, TooManyLabelsException {
        int labelId = schemaWriteOperations.labelGetOrCreateForName(indexDefinition.getLabel().name());
        int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(schemaWriteOperations, indexDefinition);
        return IndexDescriptorFactory.getNodePropertyDescriptor(labelId, propertyKeyIds);
    }

    public static NodePropertyDescriptor getTokens(ReadOperations readOperations, IndexDefinition indexDefinition) {
        int labelId = readOperations.labelGetForName(indexDefinition.getLabel().name());
        int[] propertyKeyIds = PropertyNameUtils.getPropertyKeyIds(readOperations, indexDefinition.getPropertyKeys());
        return IndexDescriptorFactory.getNodePropertyDescriptor(labelId, propertyKeyIds);
    }
}

