/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class DefaultFileDeletionEventListener
implements FileWatchEventListener {
    private final Log internalLog;

    public DefaultFileDeletionEventListener(LogService logService) {
        this.internalLog = logService.getInternalLog(this.getClass());
    }

    public void fileDeleted(String fileName) {
        if (DefaultFileDeletionEventListener.isMonitoredFile(fileName)) {
            this.internalLog.error(String.format("'%s' which belongs to the store was deleted while database was running.", fileName));
        }
    }

    private static boolean isMonitoredFile(String fileName) {
        return !fileName.startsWith("neostore.transaction.db");
    }
}

