/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaComputer;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaProcessor;
import org.neo4j.kernel.api.schema_new.SchemaUtil;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.impl.store.record.AbstractSchemaRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class ConstraintRule
extends AbstractSchemaRule
implements ConstraintDescriptor.Supplier {
    private final Optional<Long> ownedIndexRule;
    private final ConstraintDescriptor descriptor;
    private SchemaComputer<Integer> lengthComputer = new SchemaComputer<Integer>(){

        @Override
        public Integer computeSpecific(LabelSchemaDescriptor schema) {
            switch (ConstraintRule.this.descriptor.type()) {
                case UNIQUE: {
                    return 6 + 8 * schema.getPropertyIds().length + 8;
                }
                case EXISTS: {
                    return 9;
                }
            }
            throw new UnsupportedOperationException("This constraint type is not yet supported by the store");
        }

        @Override
        public Integer computeSpecific(RelationTypeSchemaDescriptor schema) {
            return 9;
        }
    };

    public static ConstraintRule readUniquenessConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new ConstraintRule(id, ConstraintDescriptorFactory.uniqueForLabel(labelId, ConstraintRule.readPropertyKeys(buffer)), ConstraintRule.readOwnedIndexRule(buffer));
    }

    public static ConstraintRule readNodePropertyExistenceConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new ConstraintRule(id, ConstraintDescriptorFactory.existsForLabel(labelId, ConstraintRule.readPropertyKey(buffer)), Optional.empty());
    }

    public static ConstraintRule readRelPropertyExistenceConstraintRule(long id, int relTypeId, ByteBuffer buffer) {
        return new ConstraintRule(id, ConstraintDescriptorFactory.existsForRelType(relTypeId, ConstraintRule.readPropertyKey(buffer)), Optional.empty());
    }

    public static ConstraintRule constraintRule(long id, ConstraintDescriptor descriptor) {
        return new ConstraintRule(id, descriptor, Optional.empty());
    }

    public static ConstraintRule constraintRule(long id, ConstraintDescriptor descriptor, long ownedIndexRule) {
        return new ConstraintRule(id, descriptor, Optional.of(ownedIndexRule));
    }

    private static int readPropertyKey(ByteBuffer buffer) {
        return buffer.getInt();
    }

    private static int[] readPropertyKeys(ByteBuffer buffer) {
        int[] keys = new int[buffer.get()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = IoPrimitiveUtils.safeCastLongToInt(buffer.getLong());
        }
        return keys;
    }

    private static Optional<Long> readOwnedIndexRule(ByteBuffer buffer) {
        return Optional.of(buffer.getLong());
    }

    private ConstraintRule(long id, ConstraintDescriptor descriptor, Optional<Long> ownedIndexRule) {
        super(id);
        this.descriptor = descriptor;
        this.ownedIndexRule = ownedIndexRule;
    }

    public String toString() {
        return "ConstraintRule[id=" + this.id + ", descriptor=" + this.descriptor.userDescription(SchemaUtil.noopTokenNameLookup) + ", ownedIndex=" + this.ownedIndexRule + "]";
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor() {
        return this.descriptor.schema();
    }

    @Override
    public ConstraintDescriptor getConstraintDescriptor() {
        return this.descriptor;
    }

    public long getOwnedIndex() {
        return this.ownedIndexRule.orElseThrow(IllegalStateException::new);
    }

    @Override
    public int length() {
        return this.descriptor.schema().computeWith(this.lengthComputer);
    }

    @Override
    public void serialize(ByteBuffer target) {
        new Serializer(target).process(this.descriptor.schema());
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ConstraintRule) {
            ConstraintRule that = (ConstraintRule)o;
            return this.descriptor.equals(that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    class Serializer
    implements SchemaProcessor {
        private final ByteBuffer buffer;

        Serializer(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void processSpecific(LabelSchemaDescriptor schema) {
            switch (ConstraintRule.this.descriptor.type()) {
                case UNIQUE: {
                    this.buffer.putInt(schema.getLabelId());
                    this.buffer.put(SchemaRule.Kind.UNIQUENESS_CONSTRAINT.id());
                    this.buffer.put((byte)schema.getPropertyIds().length);
                    for (int propertyKeyId : schema.getPropertyIds()) {
                        this.buffer.putLong(propertyKeyId);
                    }
                    if (!ConstraintRule.this.ownedIndexRule.isPresent()) break;
                    this.buffer.putLong((Long)ConstraintRule.this.ownedIndexRule.get());
                    break;
                }
                case EXISTS: {
                    this.buffer.putInt(schema.getLabelId());
                    this.buffer.put(SchemaRule.Kind.NODE_PROPERTY_EXISTENCE_CONSTRAINT.id());
                    this.buffer.putInt(schema.getPropertyIds()[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This constraint type is not yet supported by the store");
                }
            }
        }

        @Override
        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            this.buffer.putInt(schema.getRelTypeId());
            this.buffer.put(SchemaRule.Kind.RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT.id());
            this.buffer.putInt(schema.getPropertyIds()[0]);
        }
    }
}

