/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeConstraintDefinition;

public class NodePropertyExistenceConstraintDefinition
extends NodeConstraintDefinition {
    public NodePropertyExistenceConstraintDefinition(InternalSchemaActions actions, Label label, String[] propertyKeys) {
        super(actions, label, propertyKeys);
    }

    protected NodePropertyExistenceConstraintDefinition(InternalSchemaActions actions, IndexDefinition indexDefinition) {
        super(actions, indexDefinition);
    }

    public void drop() {
        this.assertInUnterminatedTransaction();
        this.actions.dropNodePropertyExistenceConstraint(new IndexDefinitionImpl(this.actions, this.label, this.propertyKeys, true));
    }

    public ConstraintType getConstraintType() {
        this.assertInUnterminatedTransaction();
        return ConstraintType.NODE_PROPERTY_EXISTENCE;
    }

    @Override
    public String toString() {
        if (this.propertyKeys.length == 1) {
            return String.format("ON (%1$s:%2$s) ASSERT exists(%3$s)", this.label.name().toLowerCase(), this.label.name(), this.propertyText());
        }
        return String.format("ON (%1$s:%2$s) ASSERT %3$s IS COMPOSITE KEY", this.label.name().toLowerCase(), this.label.name(), this.propertyText());
    }
}

