/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class IndexPopulationJob
implements Runnable {
    private final IndexingService.Monitor monitor;
    private final MultipleIndexPopulator multiPopulator;
    private final IndexStoreView storeView;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private final Runnable schemaStateChangeCallback;
    private volatile StoreScan<IndexPopulationFailedKernelException> storeScan;
    private volatile boolean cancelled;

    public IndexPopulationJob(IndexStoreView storeView, MultipleIndexPopulator multiPopulator, IndexingService.Monitor monitor, Runnable schemaStateChangeCallback) {
        this.multiPopulator = multiPopulator;
        this.storeView = storeView;
        this.schemaStateChangeCallback = schemaStateChangeCallback;
        this.monitor = monitor;
    }

    public void addPopulator(IndexPopulator populator, long indexId, IndexDescriptor descriptor, IndexConfiguration config, SchemaIndexProvider.Descriptor providerDescriptor, String indexUserDescription, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory) {
        assert (this.storeScan == null) : "Population have already started, too late to add populators at this point";
        this.multiPopulator.addPopulator(populator, indexId, descriptor, providerDescriptor, config, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    @Override
    public void run() {
        String oldThreadName;
        block8: {
            assert (this.multiPopulator.hasPopulators()) : "No index populators was added so there'd be no point in running this job";
            assert (this.storeScan == null) : "Population have already started";
            oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("Index populator");
            this.multiPopulator.create();
            this.multiPopulator.replaceIndexCounts(0L, 0L, 0L);
            this.indexAllNodes();
            this.verifyDeferredConstraints();
            if (!this.cancelled) break block8;
            this.multiPopulator.cancel();
            this.doneSignal.countDown();
            Thread.currentThread().setName(oldThreadName);
            return;
        }
        try {
            try {
                this.multiPopulator.flipAfterPopulation();
                this.schemaStateChangeCallback.run();
            }
            catch (Throwable t) {
                this.multiPopulator.fail(t);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.doneSignal.countDown();
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private void indexAllNodes() throws IndexPopulationFailedKernelException {
        this.storeScan = this.multiPopulator.indexAllNodes();
        this.storeScan.run();
    }

    public PopulationProgress getPopulationProgress() {
        if (this.storeScan == null) {
            return PopulationProgress.NONE;
        }
        return this.storeScan.getProgress();
    }

    private void verifyDeferredConstraints() {
        this.monitor.verifyDeferredConstraints();
        this.multiPopulator.verifyAllDeferredConstraints(this.storeView);
    }

    public Future<Void> cancel() {
        if (this.storeScan != null) {
            this.cancelled = true;
            this.storeScan.stop();
        }
        return FutureAdapter.latchGuardedValue(Suppliers.singleton(null), this.doneSignal, "Index population job cancel");
    }

    public void update(NodePropertyUpdate update) {
        this.multiPopulator.queue(update);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + this.multiPopulator + "]";
    }

    public void awaitCompletion() throws InterruptedException {
        this.doneSignal.await();
    }
}

