/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.QueryRegistrationOperations;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.util.MonotonicCounter;
import org.neo4j.time.CpuClock;
import org.neo4j.time.SystemNanoClock;

public class StackingQueryRegistrationOperations
implements QueryRegistrationOperations {
    private final MonotonicCounter lastQueryId = MonotonicCounter.newAtomicMonotonicCounter();
    private final SystemNanoClock clock;

    public StackingQueryRegistrationOperations(SystemNanoClock clock) {
        this.clock = clock;
    }

    @Override
    public Stream<ExecutingQuery> executingQueries(KernelStatement statement) {
        return statement.executingQueryList().queries();
    }

    @Override
    public void registerExecutingQuery(KernelStatement statement, ExecutingQuery executingQuery) {
        statement.startQueryExecution(executingQuery);
    }

    @Override
    public ExecutingQuery startQueryExecution(KernelStatement statement, ClientConnectionInfo clientConnection, String queryText, Map<String, Object> queryParameters) {
        long queryId = this.lastQueryId.incrementAndGet();
        Thread thread = Thread.currentThread();
        ExecutingQuery executingQuery = new ExecutingQuery(queryId, clientConnection, statement.username(), queryText, queryParameters, statement.getTransaction().getMetaData(), statement.locks()::activeLockCount, thread, this.clock, CpuClock.CPU_CLOCK);
        this.registerExecutingQuery(statement, executingQuery);
        return executingQuery;
    }

    @Override
    public void unregisterExecutingQuery(KernelStatement statement, ExecutingQuery executingQuery) {
        statement.stopQueryExecution(executingQuery);
    }
}

