/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;

public class DataIntegrityValidatingStatementOperations
implements KeyWriteOperations,
SchemaWriteOperations {
    private final KeyWriteOperations keyWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;

    public DataIntegrityValidatingStatementOperations(KeyWriteOperations keyWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate) {
        this.keyWriteDelegate = keyWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKey) throws IllegalTokenNameException {
        return this.keyWriteDelegate.propertyKeyGetOrCreateForName(state, this.checkValidTokenName(propertyKey));
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) throws IllegalTokenNameException {
        return this.keyWriteDelegate.relationshipTypeGetOrCreateForName(state, this.checkValidTokenName(relationshipTypeName));
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String label) throws IllegalTokenNameException, TooManyLabelsException {
        return this.keyWriteDelegate.labelGetOrCreateForName(state, this.checkValidTokenName(label));
    }

    @Override
    public void labelCreateForName(KernelStatement state, String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        this.keyWriteDelegate.labelCreateForName(state, labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(KernelStatement state, String propertyKeyName, int id) throws IllegalTokenNameException {
        this.keyWriteDelegate.propertyKeyCreateForName(state, propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(KernelStatement state, String relationshipTypeName, int id) throws IllegalTokenNameException {
        this.keyWriteDelegate.relationshipTypeCreateForName(state, relationshipTypeName, id);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException {
        this.checkIndexExistence(state, SchemaKernelException.OperationContext.INDEX_CREATION, descriptor);
        return this.schemaWriteDelegate.indexCreate(state, descriptor);
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor index) throws DropIndexFailureException {
        try {
            this.assertIsNotUniqueIndex(index, this.schemaReadDelegate.uniqueIndexesGetForLabel(state, index.getLabelId()));
            this.assertIndexExists(index, this.schemaReadDelegate.indexesGetForLabel(state, index.getLabelId()));
        }
        catch (IndexBelongsToConstraintException | NoSuchIndexException e) {
            throw new DropIndexFailureException(index.descriptor(), e);
        }
        this.schemaWriteDelegate.indexDrop(state, index);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor index) throws DropIndexFailureException {
        this.schemaWriteDelegate.uniqueIndexDrop(state, index);
    }

    @Override
    public UniquenessConstraint uniquePropertyConstraintCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException {
        Iterator<NodePropertyConstraint> constraints = this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, descriptor);
        while (constraints.hasNext()) {
            PropertyConstraint constraint = constraints.next();
            if (!(constraint instanceof UniquenessConstraint)) continue;
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new StatementTokenNameLookup(state.readOperations()));
        }
        this.checkIndexExistence(state, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, descriptor);
        return this.schemaWriteDelegate.uniquePropertyConstraintCreate(state, descriptor);
    }

    @Override
    public NodePropertyExistenceConstraint nodePropertyExistenceConstraintCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException {
        Iterator<NodePropertyConstraint> constraints = this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, descriptor);
        while (constraints.hasNext()) {
            NodePropertyConstraint constraint = constraints.next();
            if (!(constraint instanceof NodePropertyExistenceConstraint)) continue;
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new StatementTokenNameLookup(state.readOperations()));
        }
        return this.schemaWriteDelegate.nodePropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public RelationshipPropertyExistenceConstraint relationshipPropertyExistenceConstraintCreate(KernelStatement state, RelationshipPropertyDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException {
        Iterator<RelationshipPropertyConstraint> constraints = this.schemaReadDelegate.constraintsGetForRelationshipTypeAndPropertyKey(state, descriptor);
        while (constraints.hasNext()) {
            RelationshipPropertyConstraint constraint = constraints.next();
            if (!(constraint instanceof RelationshipPropertyExistenceConstraint)) continue;
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new StatementTokenNameLookup(state.readOperations()));
        }
        return this.schemaWriteDelegate.relationshipPropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public void constraintDrop(KernelStatement state, NodePropertyConstraint constraint) throws DropConstraintFailureException {
        try {
            this.assertConstraintExists(constraint, this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, constraint.descriptor()));
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException(constraint, (Throwable)e);
        }
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    @Override
    public void constraintDrop(KernelStatement state, RelationshipPropertyConstraint constraint) throws DropConstraintFailureException {
        try {
            this.assertConstraintExists(constraint, this.schemaReadDelegate.constraintsGetForRelationshipTypeAndPropertyKey(state, constraint.descriptor()));
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException(constraint, (Throwable)e);
        }
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    private void checkIndexExistence(KernelStatement state, SchemaKernelException.OperationContext context, NodePropertyDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException {
        for (IndexDescriptor index : Iterators.loop(this.schemaReadDelegate.indexesGetForLabel(state, descriptor.getLabelId()))) {
            if (!index.equals(descriptor)) continue;
            throw new AlreadyIndexedException(index.descriptor(), context);
        }
        for (IndexDescriptor index : Iterators.loop(this.schemaReadDelegate.uniqueIndexesGetForLabel(state, descriptor.getLabelId()))) {
            if (!index.equals(descriptor)) continue;
            throw new AlreadyConstrainedException(new UniquenessConstraint(descriptor), context, new StatementTokenNameLookup(state.readOperations()));
        }
    }

    private String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty()) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }

    private void assertIsNotUniqueIndex(IndexDescriptor index, Iterator<IndexDescriptor> uniqueIndexes) throws IndexBelongsToConstraintException {
        while (uniqueIndexes.hasNext()) {
            IndexDescriptor uniqueIndex = uniqueIndexes.next();
            if (!uniqueIndex.equals(index)) continue;
            throw new IndexBelongsToConstraintException(index.descriptor());
        }
    }

    private void assertIndexExists(IndexDescriptor index, Iterator<IndexDescriptor> indexes) throws NoSuchIndexException {
        for (IndexDescriptor existing : Iterators.loop(indexes)) {
            if (!existing.equals(index)) continue;
            return;
        }
        throw new NoSuchIndexException(index.descriptor());
    }

    private <C extends PropertyConstraint> void assertConstraintExists(C constraint, Iterator<C> existingConstraints) throws NoSuchConstraintException {
        while (existingConstraints.hasNext()) {
            PropertyConstraint existing = (PropertyConstraint)existingConstraints.next();
            if (!existing.equals(constraint)) continue;
            return;
        }
        throw new NoSuchConstraintException(constraint);
    }
}

