/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.ConnectorValidator;
import org.neo4j.kernel.configuration.Settings;

public class BoltConnectorValidator
extends ConnectorValidator {
    public BoltConnectorValidator() {
        super(Connector.ConnectorType.BOLT);
    }

    @Override
    @Nonnull
    protected Optional<Setting> getSettingFor(@Nonnull String settingName, @Nonnull Map<String, String> params) {
        String subsetting;
        String[] parts = settingName.split("\\.");
        switch (subsetting = parts[3]) {
            case "tls_level": {
                return Optional.of(Settings.setting(settingName, Settings.options(BoltConnector.EncryptionLevel.class), BoltConnector.EncryptionLevel.OPTIONAL.name()));
            }
            case "address": 
            case "listen_address": {
                return Optional.of(Settings.listenAddress(settingName, 7687));
            }
            case "advertised_address": {
                return Optional.of(Settings.advertisedAddress(settingName, Settings.listenAddress(settingName, 7687)));
            }
        }
        return super.getSettingFor(settingName, params);
    }
}

