/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;

public abstract class SchemaKernelException
extends KernelException {
    protected SchemaKernelException(Status statusCode, Throwable cause, String message, Object ... parameters) {
        super(statusCode, cause, message, parameters);
    }

    public SchemaKernelException(Status statusCode, String message, Throwable cause) {
        super(statusCode, cause, message, new Object[0]);
    }

    public SchemaKernelException(Status statusCode, String message) {
        super(statusCode, message, new Object[0]);
    }

    protected static String messageWithLabelAndPropertyName(TokenNameLookup tokenNameLookup, String formatString, NodePropertyDescriptor descriptor) {
        if (tokenNameLookup != null) {
            return String.format(formatString, tokenNameLookup.labelGetName(descriptor.getLabelId()), descriptor.propertyNameText(tokenNameLookup));
        }
        return String.format(formatString, "label[" + descriptor.getLabelId() + "]", "key[" + descriptor.propertyIdText() + "]");
    }

    public static enum OperationContext {
        INDEX_CREATION,
        CONSTRAINT_CREATION;

    }
}

