/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.ConstraintViolationKernelException;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;

public class NodePropertyExistenceConstraintViolationKernelException
extends ConstraintViolationKernelException {
    private final NodePropertyDescriptor descriptor;
    private final long nodeId;

    public NodePropertyExistenceConstraintViolationKernelException(NodePropertyDescriptor descriptor, long nodeId) {
        super("Node %d with label %d must have the property %d", nodeId, descriptor.getEntityId(), descriptor.getPropertyKeyId());
        this.descriptor = descriptor;
        this.nodeId = nodeId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Node %d with label \"%s\" must have the property \"%s\" due to a constraint", this.nodeId, this.descriptor.entityNameText(tokenNameLookup), this.descriptor.propertyNameText(tokenNameLookup));
    }
}

