/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyRecordChange;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.IdPrettyPrinter;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.storageengine.api.schema.SchemaRule;

public abstract class Command
implements StorageCommand {
    private int keyHash;
    private long key;
    private Mode mode;

    protected final void setup(long key, Mode mode) {
        this.mode = mode;
        this.keyHash = (int)(key >>> 32 ^ key);
        this.key = key;
    }

    public int hashCode() {
        return this.keyHash;
    }

    public abstract String toString();

    public long getKey() {
        return this.key;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass().equals(this.getClass()) && this.getKey() == ((Command)o).getKey();
    }

    public abstract boolean handle(CommandVisitor var1) throws IOException;

    protected String beforeAndAfterToString(AbstractBaseRecord before, AbstractBaseRecord after) {
        return String.format(" -%s%n         +%s", before, after);
    }

    void writeDynamicRecords(WritableChannel channel, Collection<DynamicRecord> records) throws IOException {
        this.writeDynamicRecords(channel, records, records.size());
    }

    void writeDynamicRecords(WritableChannel channel, Iterable<DynamicRecord> records, int size) throws IOException {
        channel.putInt(size);
        for (DynamicRecord record : records) {
            this.writeDynamicRecord(channel, record);
        }
    }

    void writeDynamicRecord(WritableChannel channel, DynamicRecord record) throws IOException {
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            if (record.isStartRecord()) {
                inUse = (byte)(inUse | Record.FIRST_IN_CHAIN.byteValue());
            }
            channel.putLong(record.getId()).putInt(record.getTypeAsInt()).put(inUse).putInt(record.getLength()).putLong(record.getNextBlock());
            byte[] data = record.getData();
            assert (data != null);
            channel.put(data, data.length);
        } else {
            byte inUse = Record.NOT_IN_USE.byteValue();
            channel.putLong(record.getId()).putInt(record.getTypeAsInt()).put(inUse);
        }
    }

    public static class RelationshipCountsCommand
    extends Command {
        private final int startLabelId;
        private final int typeId;
        private final int endLabelId;
        private final long delta;

        public RelationshipCountsCommand(int startLabelId, int typeId, int endLabelId, long delta) {
            this.setup(typeId, Mode.UPDATE);
            assert (delta != 0L) : "Tried to create a RelationshipCountsCommand for something that didn't change any count";
            this.startLabelId = startLabelId;
            this.typeId = typeId;
            this.endLabelId = endLabelId;
            this.delta = delta;
        }

        @Override
        public String toString() {
            return String.format("UpdateCounts[(%s)-%s->(%s) %s %d]", IdPrettyPrinter.label(this.startLabelId), IdPrettyPrinter.relationshipType(this.typeId), IdPrettyPrinter.label(this.endLabelId), this.delta < 0L ? "-" : "+", Math.abs(this.delta));
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipCountsCommand(this);
        }

        public int startLabelId() {
            return this.startLabelId;
        }

        public int typeId() {
            return this.typeId;
        }

        public int endLabelId() {
            return this.endLabelId;
        }

        public long delta() {
            return this.delta;
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)16);
            channel.putInt(this.startLabelId()).putInt(this.typeId()).putInt(this.endLabelId()).putLong(this.delta());
        }
    }

    public static class NodeCountsCommand
    extends Command {
        private final int labelId;
        private final long delta;

        public NodeCountsCommand(int labelId, long delta) {
            this.setup(labelId, Mode.UPDATE);
            assert (delta != 0L) : "Tried to create a NodeCountsCommand for something that didn't change any count";
            this.labelId = labelId;
            this.delta = delta;
        }

        @Override
        public String toString() {
            return String.format("UpdateCounts[(%s) %s %d]", IdPrettyPrinter.label(this.labelId), this.delta < 0L ? "-" : "+", Math.abs(this.delta));
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitNodeCountsCommand(this);
        }

        public int labelId() {
            return this.labelId;
        }

        public long delta() {
            return this.delta;
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)17);
            channel.putInt(this.labelId()).putLong(this.delta());
        }
    }

    public static class SchemaRuleCommand
    extends Command {
        private final SchemaRecord recordsBefore;
        private final SchemaRecord recordsAfter;
        private final SchemaRule schemaRule;

        public SchemaRuleCommand(Collection<DynamicRecord> recordsBefore, Collection<DynamicRecord> recordsAfter, SchemaRule schemaRule) {
            this(new SchemaRecord(recordsBefore), new SchemaRecord(recordsAfter), schemaRule);
        }

        public SchemaRuleCommand(SchemaRecord recordsBefore, SchemaRecord recordsAfter, SchemaRule schemaRule) {
            this.setup(((DynamicRecord)Iterables.first((Iterable)recordsAfter)).getId(), Mode.fromRecordState((AbstractBaseRecord)Iterables.first((Iterable)recordsAfter)));
            this.recordsBefore = recordsBefore;
            this.recordsAfter = recordsAfter;
            this.schemaRule = schemaRule;
        }

        @Override
        public String toString() {
            if (this.schemaRule != null) {
                return (Object)((Object)this.getMode()) + ":" + this.schemaRule.toString();
            }
            return "SchemaRule" + this.recordsAfter;
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitSchemaRuleCommand(this);
        }

        public SchemaRecord getRecordsAfter() {
            return this.recordsAfter;
        }

        public SchemaRule getSchemaRule() {
            return this.schemaRule;
        }

        public SchemaRecord getRecordsBefore() {
            return this.recordsBefore;
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)7);
            this.writeDynamicRecords(channel, this.recordsBefore, this.recordsBefore.size());
            this.writeDynamicRecords(channel, this.recordsAfter, this.recordsAfter.size());
            channel.put(((DynamicRecord)Iterables.first((Iterable)this.recordsAfter)).isCreated() ? (byte)1 : 0);
        }
    }

    public static class LabelTokenCommand
    extends TokenCommand<LabelTokenRecord> {
        public LabelTokenCommand(LabelTokenRecord before, LabelTokenRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitLabelTokenCommand(this);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)8);
            channel.putInt(((LabelTokenRecord)this.after).getIntId());
            this.writeLabelTokenRecord(channel, (LabelTokenRecord)this.before);
            this.writeLabelTokenRecord(channel, (LabelTokenRecord)this.after);
        }

        private void writeLabelTokenRecord(WritableChannel channel, LabelTokenRecord record) throws IOException {
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            channel.put(inUse).putInt(record.getNameId());
            this.writeDynamicRecords(channel, record.getNameRecords());
        }
    }

    public static class RelationshipTypeTokenCommand
    extends TokenCommand<RelationshipTypeTokenRecord> {
        public RelationshipTypeTokenCommand(RelationshipTypeTokenRecord before, RelationshipTypeTokenRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipTypeTokenCommand(this);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)4);
            channel.putInt(((RelationshipTypeTokenRecord)this.after).getIntId());
            this.writeRelationshipTypeTokenRecord(channel, (RelationshipTypeTokenRecord)this.before);
            this.writeRelationshipTypeTokenRecord(channel, (RelationshipTypeTokenRecord)this.after);
        }

        private void writeRelationshipTypeTokenRecord(WritableChannel channel, RelationshipTypeTokenRecord record) throws IOException {
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            channel.put(inUse);
            channel.putInt(record.getNameId());
            if (record.isLight()) {
                channel.putInt(0);
            } else {
                this.writeDynamicRecords(channel, record.getNameRecords());
            }
        }
    }

    public static class PropertyKeyTokenCommand
    extends TokenCommand<PropertyKeyTokenRecord> {
        public PropertyKeyTokenCommand(PropertyKeyTokenRecord before, PropertyKeyTokenRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitPropertyKeyTokenCommand(this);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)5);
            channel.putInt(((PropertyKeyTokenRecord)this.after).getIntId());
            this.writePropertyKeyTokenRecord(channel, (PropertyKeyTokenRecord)this.before);
            this.writePropertyKeyTokenRecord(channel, (PropertyKeyTokenRecord)this.after);
        }

        private void writePropertyKeyTokenRecord(WritableChannel channel, PropertyKeyTokenRecord record) throws IOException {
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            channel.put(inUse);
            channel.putInt(record.getPropertyCount()).putInt(record.getNameId());
            if (record.isLight()) {
                channel.putInt(0);
            } else {
                this.writeDynamicRecords(channel, record.getNameRecords());
            }
        }
    }

    public static abstract class TokenCommand<RECORD extends TokenRecord>
    extends Command {
        protected final RECORD before;
        protected final RECORD after;

        public TokenCommand(RECORD before, RECORD after) {
            this.setup(((AbstractBaseRecord)after).getId(), Mode.fromRecordState(after));
            this.before = before;
            this.after = after;
        }

        public RECORD getBefore() {
            return this.before;
        }

        public RECORD getAfter() {
            return this.after;
        }

        @Override
        public String toString() {
            return this.beforeAndAfterToString((AbstractBaseRecord)this.before, (AbstractBaseRecord)this.after);
        }
    }

    public static class PropertyCommand
    extends BaseCommand<PropertyRecord>
    implements PropertyRecordChange {
        public PropertyCommand(PropertyRecord before, PropertyRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitPropertyCommand(this);
        }

        public long getNodeId() {
            return ((PropertyRecord)this.after).getNodeId();
        }

        public long getRelId() {
            return ((PropertyRecord)this.after).getRelId();
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)2);
            channel.putLong(((PropertyRecord)this.after).getId());
            this.writePropertyRecord(channel, (PropertyRecord)this.before);
            this.writePropertyRecord(channel, (PropertyRecord)this.after);
        }

        private void writePropertyRecord(WritableChannel channel, PropertyRecord record) throws IOException {
            byte flags = Bits.bitFlags(Bits.bitFlag(record.inUse(), Record.IN_USE.byteValue()), Bits.bitFlag(record.getRelId() != -1L, Record.REL_PROPERTY.byteValue()), Bits.bitFlag(record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag(record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag(record.isUseFixedReferences(), (byte)16));
            channel.put(flags);
            channel.putLong(record.getNextProp()).putLong(record.getPrevProp());
            long nodeId = record.getNodeId();
            long relId = record.getRelId();
            if (nodeId != -1L) {
                channel.putLong(nodeId);
            } else if (relId != -1L) {
                channel.putLong(relId);
            } else {
                channel.putLong(-1L);
            }
            if (record.hasSecondaryUnitId()) {
                channel.putLong(record.getSecondaryUnitId());
            }
            channel.put((byte)record.numberOfProperties());
            for (PropertyBlock block : record) {
                assert (block.getSize() > 0) : record + " seems kinda broken";
                this.writePropertyBlock(channel, block);
            }
            this.writeDynamicRecords(channel, record.getDeletedRecords());
        }

        private void writePropertyBlock(WritableChannel channel, PropertyBlock block) throws IOException {
            long[] propBlockValues;
            byte blockSize = (byte)block.getSize();
            assert (blockSize > 0) : blockSize + " is not a valid block size value";
            channel.put(blockSize);
            for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
                channel.putLong(propBlockValue);
            }
            if (block.isLight()) {
                channel.putInt(0);
            } else {
                this.writeDynamicRecords(channel, block.getValueRecords());
            }
        }
    }

    public static class NeoStoreCommand
    extends BaseCommand<NeoStoreRecord> {
        public NeoStoreCommand(NeoStoreRecord before, NeoStoreRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitNeoStoreCommand(this);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)6);
            this.writeNeoStoreRecord(channel, (NeoStoreRecord)this.before);
            this.writeNeoStoreRecord(channel, (NeoStoreRecord)this.after);
        }

        private void writeNeoStoreRecord(WritableChannel channel, NeoStoreRecord record) throws IOException {
            channel.putLong(record.getNextProp());
        }
    }

    public static class RelationshipGroupCommand
    extends BaseCommand<RelationshipGroupRecord> {
        public RelationshipGroupCommand(RelationshipGroupRecord before, RelationshipGroupRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipGroupCommand(this);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)9);
            channel.putLong(((RelationshipGroupRecord)this.after).getId());
            this.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)this.before);
            this.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)this.after);
        }

        private void writeRelationshipGroupRecord(WritableChannel channel, RelationshipGroupRecord record) throws IOException {
            byte flags = Bits.bitFlags(Bits.bitFlag(record.inUse(), Record.IN_USE.byteValue()), Bits.bitFlag(record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag(record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag(record.isUseFixedReferences(), (byte)16));
            channel.put(flags);
            channel.putShort((short)record.getType());
            channel.putLong(record.getNext());
            channel.putLong(record.getFirstOut());
            channel.putLong(record.getFirstIn());
            channel.putLong(record.getFirstLoop());
            channel.putLong(record.getOwningNode());
            if (record.hasSecondaryUnitId()) {
                channel.putLong(record.getSecondaryUnitId());
            }
        }
    }

    public static class RelationshipCommand
    extends BaseCommand<RelationshipRecord> {
        public RelationshipCommand(RelationshipRecord before, RelationshipRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipCommand(this);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)3);
            channel.putLong(((RelationshipRecord)this.after).getId());
            this.writeRelationshipRecord(channel, (RelationshipRecord)this.before);
            this.writeRelationshipRecord(channel, (RelationshipRecord)this.after);
        }

        private void writeRelationshipRecord(WritableChannel channel, RelationshipRecord record) throws IOException {
            byte flags = Bits.bitFlags(Bits.bitFlag(record.inUse(), Record.IN_USE.byteValue()), Bits.bitFlag(record.isCreated(), (byte)2), Bits.bitFlag(record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag(record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag(record.isUseFixedReferences(), (byte)16));
            channel.put(flags);
            if (record.inUse()) {
                channel.putLong(record.getFirstNode()).putLong(record.getSecondNode()).putInt(record.getType()).putLong(record.getFirstPrevRel()).putLong(record.getFirstNextRel()).putLong(record.getSecondPrevRel()).putLong(record.getSecondNextRel()).putLong(record.getNextProp()).put((byte)((record.isFirstInFirstChain() ? 1 : 0) | (record.isFirstInSecondChain() ? 2 : 0)));
                if (record.hasSecondaryUnitId()) {
                    channel.putLong(record.getSecondaryUnitId());
                }
            } else {
                channel.putInt(record.getType());
            }
        }
    }

    public static class NodeCommand
    extends BaseCommand<NodeRecord> {
        public NodeCommand(NodeRecord before, NodeRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitNodeCommand(this);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)1);
            channel.putLong(((NodeRecord)this.after).getId());
            this.writeNodeRecord(channel, (NodeRecord)this.before);
            this.writeNodeRecord(channel, (NodeRecord)this.after);
        }

        private boolean writeNodeRecord(WritableChannel channel, NodeRecord record) throws IOException {
            byte flags = Bits.bitFlags(Bits.bitFlag(record.inUse(), Record.IN_USE.byteValue()), Bits.bitFlag(record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag(record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag(record.isUseFixedReferences(), (byte)16));
            channel.put(flags);
            if (record.inUse()) {
                channel.put(record.isDense() ? (byte)1 : 0);
                channel.putLong(record.getNextRel()).putLong(record.getNextProp());
                channel.putLong(record.getLabelField());
                if (record.hasSecondaryUnitId()) {
                    channel.putLong(record.getSecondaryUnitId());
                }
            }
            this.writeDynamicRecords(channel, record.getDynamicLabelRecords());
            return false;
        }
    }

    public static abstract class BaseCommand<RECORD extends AbstractBaseRecord>
    extends Command {
        protected final RECORD before;
        protected final RECORD after;

        public BaseCommand(RECORD before, RECORD after) {
            this.setup(((AbstractBaseRecord)after).getId(), Mode.fromRecordState(after));
            this.before = before;
            this.after = after;
        }

        @Override
        public String toString() {
            return this.beforeAndAfterToString((AbstractBaseRecord)this.before, (AbstractBaseRecord)this.after);
        }

        public RECORD getBefore() {
            return this.before;
        }

        public RECORD getAfter() {
            return this.after;
        }
    }

    public static enum Mode {
        CREATE,
        UPDATE,
        DELETE;


        public static Mode fromRecordState(boolean created, boolean inUse) {
            if (!inUse) {
                return DELETE;
            }
            if (created) {
                return CREATE;
            }
            return UPDATE;
        }

        public static Mode fromRecordState(AbstractBaseRecord record) {
            return Mode.fromRecordState(record.isCreated(), record.inUse());
        }
    }
}

