/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;

public class JmxQueryProcedure
extends CallableProcedure.BasicProcedure {
    private final MBeanServer jmxServer;

    public JmxQueryProcedure(QualifiedName name, MBeanServer jmxServer) {
        super(ProcedureSignature.procedureSignature(name).in("query", Neo4jTypes.NTString).out("name", Neo4jTypes.NTString).out("description", Neo4jTypes.NTString).out("attributes", Neo4jTypes.NTMap).description("Query JMX management data by domain and name. For instance, \"org.neo4j:*\"").build());
        this.jmxServer = jmxServer;
    }

    @Override
    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
        String query = input[0].toString();
        try {
            Iterator<ObjectName> names = this.jmxServer.queryNames(new ObjectName(query), null).iterator();
            return RawIterator.from(() -> {
                if (!names.hasNext()) {
                    return null;
                }
                ObjectName name = (ObjectName)names.next();
                try {
                    MBeanInfo beanInfo = this.jmxServer.getMBeanInfo(name);
                    return new Object[]{name.getCanonicalName(), beanInfo.getDescription(), this.toNeo4jValue(name, beanInfo.getAttributes())};
                }
                catch (JMException e) {
                    throw new ProcedureException((Status)Status.General.UnknownError, (Throwable)e, "JMX error while accessing `%s`, please report this. Message was: %s", name, e.getMessage());
                }
            });
        }
        catch (MalformedObjectNameException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "'%s' is an invalid JMX name pattern. Valid queries should usethe syntax outlined in the javax.management.ObjectName API documentation.For instance, try 'org.neo4j:*' to find all JMX beans of the 'org.neo4j' domain, or '*:*' to find every JMX bean.", query);
        }
    }

    private Map<String, Object> toNeo4jValue(ObjectName name, MBeanAttributeInfo[] attributes) throws JMException {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (MBeanAttributeInfo attribute : attributes) {
            if (!attribute.isReadable()) continue;
            out.put(attribute.getName(), this.toNeo4jValue(name, attribute));
        }
        return out;
    }

    private Map<String, Object> toNeo4jValue(ObjectName name, MBeanAttributeInfo attribute) throws JMException {
        Object value;
        try {
            value = this.toNeo4jValue(this.jmxServer.getAttribute(name, attribute.getName()));
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() != null && e.getCause() instanceof UnsupportedOperationException) {
                value = null;
            }
            throw e;
        }
        return MapUtil.map((Object[])new Object[]{"description", attribute.getDescription(), "value", value});
    }

    private Object toNeo4jValue(Object attributeValue) {
        if (this.isSimpleType(attributeValue)) {
            return attributeValue;
        }
        if (attributeValue.getClass().isArray()) {
            if (this.isSimpleType(attributeValue.getClass().getComponentType())) {
                return attributeValue;
            }
            return this.toNeo4jValue((Object[])attributeValue);
        }
        if (attributeValue instanceof CompositeData) {
            return this.toNeo4jValue((CompositeData)attributeValue);
        }
        if (attributeValue instanceof ObjectName) {
            return ((ObjectName)attributeValue).getCanonicalName();
        }
        if (attributeValue instanceof TabularData) {
            return this.toNeo4jValue((Map)attributeValue);
        }
        if (attributeValue instanceof Date) {
            return ((Date)attributeValue).getTime();
        }
        return null;
    }

    private Map<String, Object> toNeo4jValue(Map<?, ?> attributeValue) {
        return attributeValue.entrySet().stream().map(e -> Pair.pair((Object)e.getKey().toString(), (Object)this.toNeo4jValue(e.getValue()))).collect(Collectors.toMap(Pair::first, Pair::other));
    }

    private List<Object> toNeo4jValue(Object[] array) {
        return Arrays.asList(array).stream().map(this::toNeo4jValue).collect(Collectors.toList());
    }

    private Map<String, Object> toNeo4jValue(CompositeData composite) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : composite.getCompositeType().keySet()) {
            properties.put(key, this.toNeo4jValue(composite.get(key)));
        }
        return MapUtil.map((Object[])new Object[]{"description", composite.getCompositeType().getDescription(), "properties", properties});
    }

    private boolean isSimpleType(Object value) {
        return value == null || this.isSimpleType(value.getClass());
    }

    private boolean isSimpleType(Class<?> cls) {
        return String.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls) || Boolean.class.isAssignableFrom(cls) || cls.isPrimitive();
    }
}

