/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.EntityItemHelper;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.txstate.RelationshipState;

public abstract class TxAbstractRelationshipCursor
extends EntityItemHelper
implements Cursor<RelationshipItem>,
RelationshipItem,
RelationshipVisitor<RuntimeException> {
    protected final TransactionState state;
    private final Consumer<TxAbstractRelationshipCursor> instanceCache;
    protected Cursor<RelationshipItem> cursor;
    private long id;
    private int type;
    private long startNodeId;
    private long endNodeId;
    protected RelationshipState relationshipState;
    protected boolean relationshipIsAddedInThisTx;

    public TxAbstractRelationshipCursor(TransactionState state, Consumer<TxAbstractRelationshipCursor> instanceCache) {
        this.state = state;
        this.instanceCache = instanceCache;
    }

    public TxAbstractRelationshipCursor init(Cursor<RelationshipItem> cursor) {
        this.cursor = cursor;
        return this;
    }

    public RelationshipItem get() {
        if (this.id == -1L) {
            throw new IllegalStateException();
        }
        return this;
    }

    @Override
    public void visit(long relId, int type, long startNode, long endNode) throws RuntimeException {
        this.id = relId;
        this.type = type;
        this.startNodeId = startNode;
        this.endNodeId = endNode;
    }

    public void close() {
        this.cursor.close();
        this.cursor = null;
        this.relationshipState = null;
        this.instanceCache.accept(this);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public long startNode() {
        return this.startNodeId;
    }

    @Override
    public long endNode() {
        return this.endNodeId;
    }

    @Override
    public long otherNode(long nodeId) {
        return this.startNodeId == nodeId ? this.endNodeId : this.startNodeId;
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.state.augmentPropertyCursor((Cursor<PropertyItem>)(this.relationshipIsAddedInThisTx ? Cursors.empty() : ((RelationshipItem)this.cursor.get()).properties()), this.relationshipState);
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        return this.state.augmentSinglePropertyCursor((Cursor<PropertyItem>)(this.relationshipIsAddedInThisTx ? Cursors.empty() : ((RelationshipItem)this.cursor.get()).property(propertyKeyId)), this.relationshipState, propertyKeyId);
    }
}

