/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txstate;

import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.storageengine.api.DegreeItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class TransactionCountingStateVisitor
extends TxStateVisitor.Delegator {
    private final RelationshipDataExtractor edge = new RelationshipDataExtractor();
    private final StoreReadLayer storeLayer;
    private final StorageStatement statement;
    private final CountsRecordState counts;
    private final ReadableTransactionState txState;

    public TransactionCountingStateVisitor(TxStateVisitor next, StoreReadLayer storeLayer, StorageStatement statement, ReadableTransactionState txState, CountsRecordState counts) {
        super(next);
        this.storeLayer = storeLayer;
        this.statement = statement;
        this.txState = txState;
        this.counts = counts;
    }

    @Override
    public void visitCreatedNode(long id) {
        this.counts.incrementNodeCount(-1, 1L);
        super.visitCreatedNode(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        block27: {
            this.counts.incrementNodeCount(-1, -1L);
            try (Cursor<NodeItem> node = this.statement.acquireSingleNodeCursor(id, AssertOpen.ALWAYS_OPEN);){
                int[] removed;
                PrimitiveIntIterator labels;
                if (!node.next() || !(labels = ((NodeItem)node.get()).getLabels()).hasNext()) break block27;
                for (int label : removed = PrimitiveIntCollections.asArray((PrimitiveIntIterator)labels)) {
                    this.counts.incrementNodeCount(label, -1L);
                }
                try (Cursor<DegreeItem> degrees = ((NodeItem)node.get()).degrees();){
                    while (degrees.next()) {
                        DegreeItem degree = (DegreeItem)degrees.get();
                        for (int label : removed) {
                            this.updateRelationshipsCountsFromDegrees(degree.type(), label, -degree.outgoing(), -degree.incoming());
                        }
                    }
                }
            }
        }
        super.visitDeletedNode(id);
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
        this.updateRelationshipCount(startNode, type, endNode, 1);
        super.visitCreatedRelationship(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        try {
            this.storeLayer.relationshipVisit(id, this.edge);
            this.updateRelationshipCount(this.edge.startNode(), this.edge.type(), this.edge.endNode(), -1);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Relationship being deleted should exist along with its nodes.", e);
        }
        super.visitDeletedRelationship(id);
    }

    @Override
    public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationKernelException {
        block30: {
            if (!added.isEmpty() || !removed.isEmpty()) {
                for (Integer label : added) {
                    this.counts.incrementNodeCount(label, 1L);
                }
                for (Integer label : removed) {
                    this.counts.incrementNodeCount(label, -1L);
                }
                try (Cursor<NodeItem> node = this.statement.acquireSingleNodeCursor(id, AssertOpen.ALWAYS_OPEN);){
                    if (!node.next()) break block30;
                    try (Cursor<DegreeItem> degrees = ((NodeItem)node.get()).degrees();){
                        while (degrees.next()) {
                            DegreeItem degree = (DegreeItem)degrees.get();
                            for (Integer label : added) {
                                this.updateRelationshipsCountsFromDegrees(degree.type(), label, degree.outgoing(), degree.incoming());
                            }
                            for (Integer label : removed) {
                                this.updateRelationshipsCountsFromDegrees(degree.type(), label, -degree.outgoing(), -degree.incoming());
                            }
                        }
                    }
                }
            }
        }
        super.visitNodeLabelChanges(id, added, removed);
    }

    private void updateRelationshipsCountsFromDegrees(int type, int label, long outgoing, long incoming) {
        this.counts.incrementRelationshipCount(label, -1, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, -1, label, incoming);
        this.counts.incrementRelationshipCount(label, type, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, type, label, incoming);
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) {
        this.updateRelationshipsCountsFromDegrees(type, -1, delta, 0L);
        PrimitiveIntIterator startLabels = this.labelsOf(startNode);
        while (startLabels.hasNext()) {
            this.updateRelationshipsCountsFromDegrees(type, startLabels.next(), delta, 0L);
        }
        PrimitiveIntIterator endLabels = this.labelsOf(endNode);
        while (endLabels.hasNext()) {
            this.updateRelationshipsCountsFromDegrees(type, endLabels.next(), 0L, delta);
        }
    }

    private PrimitiveIntIterator labelsOf(long nodeId) {
        try (Cursor<NodeItem> node = this.nodeCursor(this.statement, nodeId);){
            if (node.next()) {
                PrimitiveIntIterator primitiveIntIterator = ((NodeItem)node.get()).getLabels();
                return primitiveIntIterator;
            }
            PrimitiveIntIterator primitiveIntIterator = PrimitiveIntCollections.emptyIterator();
            return primitiveIntIterator;
        }
    }

    private Cursor<NodeItem> nodeCursor(StorageStatement statement, long nodeId) {
        Cursor<NodeItem> cursor = statement.acquireSingleNodeCursor(nodeId, AssertOpen.ALWAYS_OPEN);
        return this.txState.augmentSingleNodeCursor(cursor, nodeId);
    }
}

