/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.TransactionApplyKernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.BatchTransactionApplierFacade;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.LegacyBatchIndexApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.cache.BridgingCacheAccess;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.TransactionToRecordStateVisitor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.DefaultIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.command.CacheInvalidationBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.HighIdBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexUpdatesWork;
import org.neo4j.kernel.impl.transaction.command.LabelUpdateWork;
import org.neo4j.kernel.impl.transaction.command.NeoStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipDeleter;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class RecordStorageEngine
implements StorageEngine,
Lifecycle {
    private static final boolean takePropertyReadLocks = FeatureToggles.flag(RecordStorageEngine.class, (String)"propertyReadLocks", (boolean)false);
    private static final boolean safeIdBuffering = FeatureToggles.flag(RecordStorageEngine.class, (String)"safeIdBuffering", (boolean)true);
    private final StoreReadLayer storeLayer;
    private final IndexingService indexingService;
    private final NeoStores neoStores;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final DatabaseHealth databaseHealth;
    private final IndexConfigStore indexConfigStore;
    private final SchemaCache schemaCache;
    private final IntegrityValidator integrityValidator;
    private final CacheAccessBackDoor cacheAccess;
    private final LabelScanStore labelScanStore;
    private final DefaultSchemaIndexProviderMap schemaIndexProviderMap;
    private final LegacyIndexApplierLookup legacyIndexApplierLookup;
    private final Runnable schemaStateChangeCallback;
    private final SchemaStorage schemaStorage;
    private final ConstraintSemantics constraintSemantics;
    private final IdOrderingQueue legacyIndexTransactionOrdering;
    private final JobScheduler scheduler;
    private final LockService lockService;
    private final WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync;
    private final CommandReaderFactory commandReaderFactory;
    private final WorkSync<IndexingService, IndexUpdatesWork> indexUpdatesSync;
    private final NeoStoreIndexStoreView indexStoreView;
    private final LegacyIndexProviderLookup legacyIndexProviderLookup;
    private final PropertyPhysicalToLogicalConverter indexUpdatesConverter;
    private final Supplier<StorageStatement> storeStatementSupplier;
    private final IdController idController;
    private final Loaders loaders;
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter relationshipDeleter;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;

    public RecordStorageEngine(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, IdReuseEligibility eligibleForReuse, IdTypeConfigurationProvider idTypeConfigurationProvider, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, Runnable schemaStateChangeCallback, ConstraintSemantics constraintSemantics, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LockService lockService, SchemaIndexProvider indexProvider, IndexingService.Monitor indexingServiceMonitor, DatabaseHealth databaseHealth, LabelScanStoreProvider labelScanStoreProvider, LegacyIndexProviderLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore, IdOrderingQueue legacyIndexTransactionOrdering, Supplier<KernelTransactionsSnapshot> transactionsSnapshotSupplier) {
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokens;
        this.labelTokenHolder = labelTokens;
        this.schemaStateChangeCallback = schemaStateChangeCallback;
        this.scheduler = scheduler;
        this.lockService = lockService;
        this.databaseHealth = databaseHealth;
        this.legacyIndexProviderLookup = legacyIndexProviderLookup;
        this.indexConfigStore = indexConfigStore;
        this.constraintSemantics = constraintSemantics;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
        this.idController = this.createStorageIdController(idGeneratorFactory, eligibleForReuse, idTypeConfigurationProvider, transactionsSnapshotSupplier);
        StoreFactory factory = new StoreFactory(storeDir, config, this.idController.getIdGeneratorFactory(), pageCache, fs, logProvider);
        this.neoStores = factory.openAllNeoStores(true);
        try {
            this.indexUpdatesConverter = new PropertyPhysicalToLogicalConverter(this.neoStores.getPropertyStore());
            this.schemaCache = new SchemaCache(constraintSemantics, Collections.emptyList());
            this.schemaStorage = new SchemaStorage(this.neoStores.getSchemaStore());
            this.labelScanStore = labelScanStoreProvider.getLabelScanStore();
            this.schemaIndexProviderMap = new DefaultSchemaIndexProviderMap(indexProvider);
            this.indexStoreView = new DynamicIndexStoreView(this.labelScanStore, lockService, this.neoStores);
            this.indexingService = IndexingServiceFactory.createIndexingService(config, scheduler, this.schemaIndexProviderMap, this.indexStoreView, tokenNameLookup, Iterators.asList(new SchemaStorage(this.neoStores.getSchemaStore()).allIndexRules()), logProvider, indexingServiceMonitor, schemaStateChangeCallback);
            this.integrityValidator = new IntegrityValidator(this.neoStores, this.indexingService);
            this.cacheAccess = new BridgingCacheAccess(this.schemaCache, schemaStateChangeCallback, propertyKeyTokenHolder, relationshipTypeTokens, labelTokens);
            this.storeStatementSupplier = this.storeStatementSupplier(this.neoStores);
            DiskLayer diskLayer = new DiskLayer(propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, this.schemaStorage, this.neoStores, this.indexingService, this.storeStatementSupplier);
            this.storeLayer = new CacheLayer(diskLayer, this.schemaCache);
            this.legacyIndexApplierLookup = new LegacyIndexApplierLookup.Direct(legacyIndexProviderLookup);
            this.labelScanStoreSync = new WorkSync(this.labelScanStore::newWriter);
            this.commandReaderFactory = new RecordStorageCommandReaderFactory();
            this.indexUpdatesSync = new WorkSync((Object)this.indexingService);
            this.loaders = new Loaders(this.neoStores);
            RelationshipGroupGetter relationshipGroupGetter = new RelationshipGroupGetter(this.neoStores.getRelationshipGroupStore());
            this.relationshipCreator = new RelationshipCreator(relationshipGroupGetter, config.get(GraphDatabaseSettings.dense_node_threshold));
            PropertyTraverser propertyTraverser = new PropertyTraverser();
            this.propertyDeleter = new PropertyDeleter(propertyTraverser);
            this.relationshipDeleter = new RelationshipDeleter(relationshipGroupGetter, this.propertyDeleter);
            this.propertyCreator = new PropertyCreator(this.neoStores.getPropertyStore(), propertyTraverser);
        }
        catch (Throwable failure) {
            this.neoStores.close();
            throw failure;
        }
    }

    private IdController createStorageIdController(IdGeneratorFactory idGeneratorFactory, IdReuseEligibility eligibleForReuse, IdTypeConfigurationProvider idTypeConfigurationProvider, Supplier<KernelTransactionsSnapshot> transactionsSnapshotSupplier) {
        return safeIdBuffering ? new BufferedIdController(idGeneratorFactory, transactionsSnapshotSupplier, eligibleForReuse, idTypeConfigurationProvider, this.scheduler) : new DefaultIdController(idGeneratorFactory);
    }

    private Supplier<StorageStatement> storeStatementSupplier(NeoStores neoStores) {
        Supplier<IndexReaderFactory> indexReaderFactory = () -> new IndexReaderFactory.Caching(this.indexingService);
        LockService lockService = takePropertyReadLocks ? this.lockService : LockService.NO_LOCK_SERVICE;
        return () -> new StoreStatement(neoStores, indexReaderFactory, this.labelScanStore::newReader, lockService);
    }

    @Override
    public StoreReadLayer storeReadLayer() {
        return this.storeLayer;
    }

    @Override
    public CommandReaderFactory commandReaderFactory() {
        return this.commandReaderFactory;
    }

    @Override
    public void createCommands(Collection<StorageCommand> commands, ReadableTransactionState txState, StorageStatement storageStatement, ResourceLocker locks, long lastTransactionIdWhenStarted) throws TransactionFailureException, CreateConstraintFailureException, ConstraintValidationKernelException {
        if (txState != null) {
            RecordChangeSet recordChangeSet = new RecordChangeSet(this.loaders);
            TransactionRecordState recordState = new TransactionRecordState(this.neoStores, this.integrityValidator, recordChangeSet, lastTransactionIdWhenStarted, locks, this.relationshipCreator, this.relationshipDeleter, this.propertyCreator, this.propertyDeleter);
            TxStateVisitor txStateVisitor = new TransactionToRecordStateVisitor(recordState, this.schemaStateChangeCallback, this.schemaStorage, this.constraintSemantics, this.schemaIndexProviderMap);
            CountsRecordState countsRecordState = new CountsRecordState();
            txStateVisitor = this.constraintSemantics.decorateTxStateVisitor(this.storeLayer, txState, txStateVisitor);
            try (TxStateVisitor visitor = txStateVisitor = new TransactionCountingStateVisitor(txStateVisitor, this.storeLayer, storageStatement, txState, countsRecordState);){
                txState.accept(txStateVisitor);
            }
            recordState.extractCommands(commands);
            countsRecordState.extractCommands(commands);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
        try (BatchTransactionApplierFacade batchApplier = this.applier(mode);){
            while (batch != null) {
                LockGroup locks;
                block37: {
                    locks = new LockGroup();
                    Throwable throwable = null;
                    try {
                        try (TransactionApplier txApplier = batchApplier.startTx(batch, locks);){
                            batch.accept(txApplier);
                        }
                        batch = batch.next();
                        if (locks == null) continue;
                        if (throwable == null) break block37;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (locks == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    locks.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            locks.close();
                            throw throwable3;
                        }
                    }
                    try {
                        locks.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                locks.close();
            }
            return;
        }
        catch (Throwable cause) {
            TransactionApplyKernelException kernelException = new TransactionApplyKernelException(cause, "Failed to apply transaction: %s", batch);
            this.databaseHealth.panic(kernelException);
            throw kernelException;
        }
    }

    protected BatchTransactionApplierFacade applier(TransactionApplicationMode mode) {
        ArrayList<BatchTransactionApplier.Adapter> appliers = new ArrayList<BatchTransactionApplier.Adapter>();
        appliers.add(new NeoStoreBatchTransactionApplier(this.neoStores, this.cacheAccess, this.lockService));
        if (mode.needsHighIdTracking()) {
            appliers.add(new HighIdBatchTransactionApplier(this.neoStores));
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            appliers.add(new CacheInvalidationBatchTransactionApplier(this.neoStores, this.cacheAccess));
        }
        appliers.add(new CountsStoreBatchTransactionApplier(this.neoStores.getCounts(), mode));
        appliers.add(new IndexBatchTransactionApplier(this.indexingService, this.labelScanStoreSync, this.indexUpdatesSync, this.neoStores.getNodeStore(), new PropertyLoader(this.neoStores), this.indexUpdatesConverter, mode));
        appliers.add(new LegacyBatchIndexApplier(this.indexConfigStore, this.legacyIndexApplierLookup, this.legacyIndexTransactionOrdering, mode));
        return new BatchTransactionApplierFacade(appliers.toArray(new BatchTransactionApplier[appliers.size()]));
    }

    public void satisfyDependencies(DependencySatisfier satisfier) {
        satisfier.satisfyDependency(this.legacyIndexApplierLookup);
        satisfier.satisfyDependency(this.cacheAccess);
        satisfier.satisfyDependency(this.schemaIndexProviderMap);
        satisfier.satisfyDependency(this.integrityValidator);
        satisfier.satisfyDependency(this.labelScanStore);
        satisfier.satisfyDependency(this.indexingService);
        satisfier.satisfyDependency(this.neoStores.getMetaDataStore());
        satisfier.satisfyDependency(this.indexStoreView);
        satisfier.satisfyDependency(this.idController);
    }

    public void init() throws Throwable {
        this.indexingService.init();
        this.labelScanStore.init();
    }

    public void start() throws Throwable {
        this.neoStores.makeStoreOk();
        this.propertyKeyTokenHolder.setInitialTokens(this.neoStores.getPropertyKeyTokenStore().getTokens(Integer.MAX_VALUE));
        this.relationshipTypeTokenHolder.setInitialTokens(this.neoStores.getRelationshipTypeTokenStore().getTokens(Integer.MAX_VALUE));
        this.labelTokenHolder.setInitialTokens(this.neoStores.getLabelTokenStore().getTokens(Integer.MAX_VALUE));
        this.neoStores.rebuildCountStoreIfNeeded();
        this.loadSchemaCache();
        this.indexingService.start();
        this.labelScanStore.start();
        this.idController.start();
    }

    @Override
    public void loadSchemaCache() {
        List schemaRules = Iterators.asList(this.neoStores.getSchemaStore().loadAllSchemaRules());
        this.schemaCache.load(schemaRules);
    }

    @Override
    public void clearBufferedIds() {
        this.idController.clear();
    }

    public void stop() throws Throwable {
        this.labelScanStore.stop();
        this.indexingService.stop();
        this.idController.stop();
    }

    public void shutdown() throws Throwable {
        this.labelScanStore.shutdown();
        this.indexingService.shutdown();
        this.neoStores.close();
    }

    @Override
    public void flushAndForce(IOLimiter limiter) {
        this.indexingService.forceAll();
        this.labelScanStore.force();
        for (IndexImplementation index : this.legacyIndexProviderLookup.all()) {
            index.force();
        }
        this.neoStores.flush(limiter);
    }

    @Override
    public void registerDiagnostics(DiagnosticsManager diagnosticsManager) {
        this.neoStores.registerDiagnostics(diagnosticsManager);
    }

    @Override
    public void forceClose() {
        try {
            this.shutdown();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void prepareForRecoveryRequired() {
        this.neoStores.deleteIdGenerators();
    }

    @Override
    public Collection<StoreFileMetadata> listStorageFiles() {
        ArrayList<StoreFileMetadata> files = new ArrayList<StoreFileMetadata>();
        for (StoreType type : StoreType.values()) {
            if (type.equals((Object)StoreType.COUNTS)) {
                this.addCountStoreFiles(files);
                continue;
            }
            RecordStore recordStore = this.neoStores.getRecordStore(type);
            StoreFileMetadata metadata = new StoreFileMetadata(recordStore.getStorageFileName(), Optional.of(type), recordStore.getRecordSize());
            files.add(metadata);
        }
        return files;
    }

    private void addCountStoreFiles(List<StoreFileMetadata> files) {
        Iterable<File> countStoreFiles = this.neoStores.getCounts().allFiles();
        for (File countStoreFile : countStoreFiles) {
            StoreFileMetadata countStoreFileMetadata = new StoreFileMetadata(countStoreFile, Optional.of(StoreType.COUNTS), 1);
            files.add(countStoreFileMetadata);
        }
    }

    public NeoStores testAccessNeoStores() {
        return this.neoStores;
    }
}

