/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Supplier;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class PhysicalLogFile
implements LogFile,
Lifecycle {
    public static final String DEFAULT_NAME = "neostore.transaction.db";
    public static final String REGEX_DEFAULT_NAME = "neostore\\.transaction\\.db";
    public static final String DEFAULT_VERSION_SUFFIX = ".";
    public static final String REGEX_DEFAULT_VERSION_SUFFIX = "\\.";
    private final long rotateAtSize;
    private final FileSystemAbstraction fileSystem;
    private final Supplier<Long> lastCommittedId;
    private final PhysicalLogFiles logFiles;
    private final LogHeaderCache logHeaderCache;
    private final Monitor monitor;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(16);
    private PositionAwarePhysicalFlushableChannel writer;
    private final LogVersionRepository logVersionRepository;
    private final LogVersionBridge readerLogVersionBridge;
    private volatile PhysicalLogVersionedStoreChannel channel;

    public PhysicalLogFile(FileSystemAbstraction fileSystem, PhysicalLogFiles logFiles, long rotateAtSize, Supplier<Long> lastCommittedId, LogVersionRepository logVersionRepository, Monitor monitor, LogHeaderCache logHeaderCache) {
        this.fileSystem = fileSystem;
        this.rotateAtSize = rotateAtSize;
        this.lastCommittedId = lastCommittedId;
        this.logVersionRepository = logVersionRepository;
        this.monitor = monitor;
        this.logHeaderCache = logHeaderCache;
        this.logFiles = logFiles;
        this.readerLogVersionBridge = new ReaderLogVersionBridge(fileSystem, logFiles);
    }

    public void init() throws IOException {
        long lastLogVersionUsed = this.logVersionRepository.getCurrentLogVersion();
        this.channel = this.createLogChannelForVersion(lastLogVersionUsed);
        this.channel.close();
    }

    public void start() throws IOException {
        long lastLogVersionUsed = this.logVersionRepository.getCurrentLogVersion();
        this.channel = this.createLogChannelForVersion(lastLogVersionUsed);
        this.channel.position(this.channel.size());
        this.writer = new PositionAwarePhysicalFlushableChannel(this.channel);
    }

    public void stop() {
    }

    public void shutdown() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public boolean rotationNeeded() throws IOException {
        return this.channel.position() >= this.rotateAtSize;
    }

    @Override
    public synchronized void rotate() throws IOException {
        this.channel = this.rotate(this.channel);
        this.writer.setChannel(this.channel);
    }

    private PhysicalLogVersionedStoreChannel rotate(LogVersionedStoreChannel currentLog) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetVersion();
        this.writer.prepareForFlush().flush();
        PhysicalLogVersionedStoreChannel newLog = this.createLogChannelForVersion(newLogVersion);
        currentLog.close();
        return newLog;
    }

    private PhysicalLogVersionedStoreChannel createLogChannelForVersion(long forVersion) throws IOException {
        File toOpen = this.logFiles.getLogFileForVersion(forVersion);
        StoreChannel storeChannel = this.fileSystem.open(toOpen, "rw");
        LogHeader header = LogHeaderReader.readLogHeader(this.headerBuffer, (ReadableByteChannel)storeChannel, false, toOpen);
        if (header == null) {
            long lastTxId = this.lastCommittedId.get();
            LogHeaderWriter.writeLogHeader(this.headerBuffer, forVersion, lastTxId);
            this.logHeaderCache.putHeader(forVersion, lastTxId);
            storeChannel.writeAll(this.headerBuffer);
            this.monitor.opened(toOpen, forVersion, lastTxId, true);
        }
        byte formatVersion = header == null ? (byte)6 : (byte)header.logFormatVersion;
        return new PhysicalLogVersionedStoreChannel(storeChannel, forVersion, formatVersion);
    }

    @Override
    public FlushablePositionAwareChannel getWriter() {
        return this.writer;
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position) throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = PhysicalLogFile.openForVersion(this.logFiles, this.fileSystem, position.getLogVersion(), false);
        logChannel.position(position.getByteOffset());
        return new ReadAheadLogChannel(logChannel, this.readerLogVersionBridge);
    }

    public static PhysicalLogVersionedStoreChannel openForVersion(PhysicalLogFiles logFiles, FileSystemAbstraction fileSystem, long version, boolean write) throws IOException {
        File fileToOpen = logFiles.getLogFileForVersion(version);
        if (!fileSystem.fileExists(fileToOpen)) {
            throw new FileNotFoundException(String.format("File does not exist [%s]", fileToOpen.getCanonicalPath()));
        }
        StoreChannel rawChannel = null;
        try {
            rawChannel = fileSystem.open(fileToOpen, write ? "rw" : "r");
            ByteBuffer buffer = ByteBuffer.allocate(16);
            LogHeader header = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)rawChannel, true, fileToOpen);
            assert (header != null && header.logVersion == version);
            PhysicalLogVersionedStoreChannel result = new PhysicalLogVersionedStoreChannel(rawChannel, version, header.logFormatVersion);
            return result;
        }
        catch (FileNotFoundException cause) {
            throw Exceptions.withCause(new FileNotFoundException(String.format("File could not be opened [%s]", fileToOpen.getCanonicalPath())), cause);
        }
        catch (Throwable unexpectedError) {
            if (rawChannel != null) {
                try {
                    rawChannel.close();
                }
                catch (IOException e) {
                    unexpectedError.addSuppressed(e);
                }
            }
            throw unexpectedError;
        }
    }

    public static PhysicalLogVersionedStoreChannel tryOpenForVersion(PhysicalLogFiles logFiles, FileSystemAbstraction fileSystem, long version, boolean write) {
        try {
            return PhysicalLogFile.openForVersion(logFiles, fileSystem, version, write);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void accept(LogFile.LogFileVisitor visitor, LogPosition startingFromPosition) throws IOException {
        try (ReadableLogChannel reader = this.getReader(startingFromPosition);){
            visitor.visit(startingFromPosition, reader);
        }
    }

    @Override
    public void accept(LogHeaderVisitor visitor) throws IOException {
        long logVersion = this.logFiles.getHighestLogVersion();
        long highTransactionId = this.lastCommittedId.get();
        while (this.logFiles.versionExists(logVersion)) {
            Long previousLogLastTxId = this.logHeaderCache.getLogHeader(logVersion);
            if (previousLogLastTxId == null) {
                LogHeader header = LogHeaderReader.readLogHeader(this.fileSystem, this.logFiles.getLogFileForVersion(logVersion));
                assert (logVersion == header.logVersion);
                this.logHeaderCache.putHeader(header.logVersion, header.lastCommittedTxId);
                previousLogLastTxId = header.lastCommittedTxId;
            }
            long lowTransactionId = previousLogLastTxId + 1L;
            LogPosition position = LogPosition.start(logVersion);
            if (!visitor.visit(position, lowTransactionId, highTransactionId)) break;
            --logVersion;
            highTransactionId = previousLogLastTxId;
        }
    }

    @Override
    public File currentLogFile() {
        return this.logFiles.getLogFileForVersion(this.logFiles.getHighestLogVersion());
    }

    @Override
    public long currentLogVersion() {
        return this.logFiles.getHighestLogVersion();
    }

    public static interface Monitor {
        public void opened(File var1, long var2, long var4, boolean var6);

        public static class Adapter
        implements Monitor {
            @Override
            public void opened(File logFile, long logVersion, long lastTransactionId, boolean clean) {
            }
        }
    }
}

