/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import org.neo4j.unsafe.impl.batchimport.input.BadCollector;
import org.neo4j.unsafe.impl.batchimport.input.Collector;

public class Collectors {
    public static Collector silentBadCollector(int tolerance) {
        return Collectors.silentBadCollector(tolerance, 7);
    }

    public static Collector silentBadCollector(int tolerance, int collect) {
        return Collectors.badCollector(new OutputStream(){

            @Override
            public void write(int i) throws IOException {
            }
        }, tolerance, collect);
    }

    public static Collector badCollector(OutputStream out, int tolerance) {
        return Collectors.badCollector(out, tolerance, 7);
    }

    public static Collector badCollector(OutputStream out, int tolerance, int collect) {
        return new BadCollector(out, tolerance, collect);
    }

    public static Function<OutputStream, Collector> badCollector(int tolerance) {
        return Collectors.badCollector(tolerance, 7);
    }

    public static Function<OutputStream, Collector> badCollector(int tolerance, int collect) {
        return out -> Collectors.badCollector(out, tolerance, collect);
    }

    public static int collect(boolean skipBadRelationships, boolean skipDuplicateNodes, boolean ignoreExtraColumns) {
        return (skipBadRelationships ? 1 : 0) | (skipDuplicateNodes ? 2 : 0) | (ignoreExtraColumns ? 4 : 0);
    }
}

