/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;

public class NodeFirstRelationshipProcessor
implements RecordProcessor<NodeRecord>,
NodeRelationshipCache.GroupVisitor {
    private final RecordStore<RelationshipGroupRecord> relGroupStore;
    private final NodeRelationshipCache cache;
    private final int relationshipType;

    public NodeFirstRelationshipProcessor(RecordStore<RelationshipGroupRecord> relGroupStore, NodeRelationshipCache cache, int relationshipType) {
        this.relGroupStore = relGroupStore;
        this.cache = cache;
        this.relationshipType = relationshipType;
    }

    @Override
    public boolean process(NodeRecord node) {
        long nodeId = node.getId();
        long firstRel = this.cache.getFirstRel(nodeId, this);
        if (firstRel != -1L) {
            node.setNextRel(firstRel);
            if (this.cache.isDense(nodeId)) {
                node.setDense(true);
            }
        }
        return true;
    }

    @Override
    public long visit(long nodeId, long next, long out, long in, long loop) {
        long id = this.relGroupStore.nextId();
        RelationshipGroupRecord groupRecord = new RelationshipGroupRecord(id);
        groupRecord.setType(this.relationshipType);
        groupRecord.setInUse(true);
        groupRecord.setFirstOut(out);
        groupRecord.setFirstIn(in);
        groupRecord.setFirstLoop(loop);
        groupRecord.setOwningNode(nodeId);
        groupRecord.setNext(next);
        this.relGroupStore.prepareForCommit(groupRecord);
        this.relGroupStore.updateRecord(groupRecord);
        return id;
    }

    @Override
    public void done() {
    }
}

