/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.util.Collections;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Service;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.builtinprocs.BuiltInDbmsProcedures;
import org.neo4j.kernel.builtinprocs.BuiltInProcedures;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.KernelDiagnostics;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.Log;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public abstract class EditionModule {
    public IdGeneratorFactory idGeneratorFactory;
    public IdTypeConfigurationProvider idTypeConfigurationProvider;
    public LabelTokenHolder labelTokenHolder;
    public PropertyKeyTokenHolder propertyKeyTokenHolder;
    public Locks lockManager;
    public StatementLocksFactory statementLocksFactory;
    public CommitProcessFactory commitProcessFactory;
    public long transactionStartTimeout;
    public RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    public TransactionHeaderInformationFactory headerInformationFactory;
    public SchemaWriteGuard schemaWriteGuard;
    public ConstraintSemantics constraintSemantics;
    public CoreAPIAvailabilityGuard coreAPIAvailabilityGuard;
    public AccessCapability accessCapability;
    public IOLimiter ioLimiter;
    public IdReuseEligibility eligibleForIdReuse;

    void registerProcedures(Procedures procedures) throws KernelException {
        procedures.registerProcedure(BuiltInProcedures.class);
        procedures.registerProcedure(BuiltInDbmsProcedures.class);
        this.registerEditionSpecificProcedures(procedures);
    }

    protected abstract void registerEditionSpecificProcedures(Procedures var1) throws KernelException;

    protected void doAfterRecoveryAndStartup(DatabaseInfo databaseInfo, DependencyResolver dependencyResolver) {
        DiagnosticsManager diagnosticsManager = (DiagnosticsManager)dependencyResolver.resolveDependency(DiagnosticsManager.class);
        NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)dependencyResolver.resolveDependency(NeoStoreDataSource.class);
        diagnosticsManager.prependProvider(new KernelDiagnostics.Versions(databaseInfo, neoStoreDataSource.getStoreId()));
        neoStoreDataSource.registerDiagnosticsWith(diagnosticsManager);
        diagnosticsManager.appendProvider(new KernelDiagnostics.StoreFiles(neoStoreDataSource.getStoreDir()));
    }

    protected void publishEditionInfo(UsageData sysInfo, DatabaseInfo databaseInfo, Config config) {
        sysInfo.set(UsageDataKeys.edition, databaseInfo.edition);
        sysInfo.set(UsageDataKeys.operationalMode, databaseInfo.operationalMode);
        config.augment(Collections.singletonMap(GraphDatabaseFacadeFactory.Configuration.editionName.name(), databaseInfo.edition.toString()));
    }

    public abstract void setupSecurityModule(PlatformModule var1, Procedures var2);

    protected static void setupSecurityModule(final PlatformModule platformModule, Log log, final Procedures procedures, String key) {
        for (SecurityModule candidate : Service.load(SecurityModule.class)) {
            if (!candidate.matches(key)) continue;
            try {
                candidate.setup(new SecurityModule.Dependencies(){

                    @Override
                    public LogService logService() {
                        return platformModule.logging;
                    }

                    @Override
                    public Config config() {
                        return platformModule.config;
                    }

                    @Override
                    public Procedures procedures() {
                        return procedures;
                    }

                    @Override
                    public JobScheduler scheduler() {
                        return platformModule.jobScheduler;
                    }

                    @Override
                    public FileSystemAbstraction fileSystem() {
                        return platformModule.fileSystem;
                    }

                    @Override
                    public LifeSupport lifeSupport() {
                        return platformModule.life;
                    }

                    @Override
                    public DependencySatisfier dependencySatisfier() {
                        return platformModule.dependencies;
                    }
                });
                return;
            }
            catch (Exception e) {
                String errorMessage = "Failed to load security module.";
                log.error(errorMessage);
                throw new RuntimeException(errorMessage, e);
            }
        }
        String errorMessage = "Failed to load security module with key '" + key + "'.";
        log.error(errorMessage);
        throw new IllegalArgumentException(errorMessage);
    }

    protected BoltConnectionTracker createSessionTracker() {
        return BoltConnectionTracker.NOOP;
    }
}

